/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.blocks.entities;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import xyz.yfrostyf.toxony.blocks.AlembicBlock;
import xyz.yfrostyf.toxony.client.gui.block.AlembicMenu;
import xyz.yfrostyf.toxony.recipes.AlembicRecipe;
import xyz.yfrostyf.toxony.recipes.inputs.PairCombineRecipeInput;
import xyz.yfrostyf.toxony.registries.BlockRegistry;
import xyz.yfrostyf.toxony.registries.DataComponentsRegistry;
import xyz.yfrostyf.toxony.registries.RecipeRegistry;
import xyz.yfrostyf.toxony.registries.SoundEventRegistry;

public class AlembicBlockEntity
extends BlockEntity
implements IItemHandler,
MenuProvider {
    public static final int MAX_FUEL = 10000;
    public static final int POTION_BOIL_TIME = 400;
    private static final int CONTAINER_SIZE = 3;
    public int fuel = 0;
    public int boilProgress = 0;
    public int boilTotalTime = 0;
    public ItemStack resultItem;
    public ItemStack returnStack;
    public ItemStackHandler itemContainer;
    private RecipeType<AlembicRecipe> recipeType;
    protected final ContainerData data = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> AlembicBlockEntity.this.fuel;
                case 1 -> AlembicBlockEntity.this.boilProgress;
                case 2 -> AlembicBlockEntity.this.boilTotalTime;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    AlembicBlockEntity.this.fuel = value;
                    break;
                }
                case 1: {
                    AlembicBlockEntity.this.boilProgress = value;
                    break;
                }
                case 2: {
                    AlembicBlockEntity.this.boilTotalTime = value;
                }
            }
        }

        public int getCount() {
            return 3;
        }
    };

    public AlembicBlockEntity(final BlockPos pos, BlockState state) {
        super(BlockRegistry.ALEMBIC_ENTITY.get(), pos, state);
        this.resultItem = ItemStack.EMPTY;
        this.returnStack = ItemStack.EMPTY;
        this.itemContainer = new ItemStackHandler(3){

            public int getSlotLimit(int slot) {
                if (slot == 0 || slot == 1) {
                    return 1;
                }
                return 64;
            }

            protected void onContentsChanged(int slot) {
                if (AlembicBlockEntity.this.level != null) {
                    AlembicBlockEntity.this.level.sendBlockUpdated(pos, AlembicBlockEntity.this.getBlockState(), AlembicBlockEntity.this.getBlockState(), 3);
                    AlembicBlockEntity.this.setChanged();
                }
            }
        };
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlockEntity entity) {
        if (!(entity instanceof AlembicBlockEntity)) {
            return;
        }
        AlembicBlockEntity blockEntity = (AlembicBlockEntity)entity;
        if (blockEntity.isBoiling() && level.getRandom().nextInt(50) == 0) {
            level.playSound(null, pos, (SoundEvent)SoundEventRegistry.ALEMBIC_BOILING.get(), SoundSource.BLOCKS, 0.8f + level.getRandom().nextFloat(), 1.0f);
        }
        if (level.isClientSide()) {
            return;
        }
        ItemStack output = blockEntity.itemContainer.getStackInSlot(0);
        ItemStack input = blockEntity.itemContainer.getStackInSlot(1);
        ItemStack fuel = blockEntity.itemContainer.getStackInSlot(2);
        ItemStack returnStack = blockEntity.getReturnStack();
        ItemStack result = blockEntity.getResultItem();
        if (!blockEntity.hasFuel() && !fuel.isEmpty()) {
            blockEntity.itemContainer.extractItem(2, 1, false);
            blockEntity.fuel = 10000;
        }
        if (blockEntity.hasFuel()) {
            if (!result.isEmpty()) {
                if (blockEntity.boilProgress < blockEntity.boilTotalTime) {
                    blockEntity.boilProgress = Mth.clamp((int)(blockEntity.boilProgress + 1), (int)0, (int)blockEntity.boilTotalTime);
                    --blockEntity.fuel;
                } else {
                    blockEntity.itemContainer.setStackInSlot(0, result);
                    blockEntity.itemContainer.setStackInSlot(1, returnStack);
                    blockEntity.resetAlembic();
                }
            }
        } else {
            blockEntity.boilProgress = Mth.clamp((int)(blockEntity.boilProgress - 2), (int)0, (int)blockEntity.boilTotalTime);
        }
        if (result.isEmpty()) {
            Optional<RecipeHolder<AlembicRecipe>> optionalRecipe = blockEntity.findRecipe();
            ItemStack resultPotion = AlembicBlockEntity.findPotionAmplify(input);
            if (optionalRecipe.isPresent()) {
                AlembicRecipe recipeFound = (AlembicRecipe)optionalRecipe.get().value();
                ItemStack newResultItem = recipeFound.assemble(new PairCombineRecipeInput(input, output), (HolderLookup.Provider)level.registryAccess());
                newResultItem = AlembicBlockEntity.handleNeedleStoredItem(input, newResultItem);
                blockEntity.setResultItem(newResultItem);
                blockEntity.returnStack = recipeFound.getRemainingingItem();
                blockEntity.boilTotalTime = recipeFound.getBoilTime();
            } else if (!resultPotion.isEmpty()) {
                blockEntity.setResultItem(resultPotion);
                blockEntity.boilTotalTime = 400;
            }
        }
        if (blockEntity.isBoiling()) {
            state = (BlockState)state.setValue((Property)AlembicBlock.LIT, (Comparable)Boolean.valueOf(true));
            level.setBlock(pos, state, 3);
            if (level.getRandom().nextInt(50) == 0) {
                level.playLocalSound(pos, (SoundEvent)SoundEventRegistry.ALEMBIC_BOILING.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
        } else {
            state = (BlockState)state.setValue((Property)AlembicBlock.LIT, (Comparable)Boolean.valueOf(false));
            level.setBlock(pos, state, 3);
        }
    }

    public Optional<RecipeHolder<AlembicRecipe>> findRecipe() {
        if (this.level == null) {
            return Optional.empty();
        }
        ItemStack inputItem = this.itemContainer.getStackInSlot(1);
        ItemStack inputToConvertItem = this.itemContainer.getStackInSlot(0);
        if (this.itemContainer.getStackInSlot(1).isEmpty()) {
            return Optional.empty();
        }
        PairCombineRecipeInput input = new PairCombineRecipeInput(inputItem, inputToConvertItem);
        return this.level.getRecipeManager().getRecipeFor(RecipeRegistry.ALEMBIC_RECIPE.get(), (RecipeInput)input, this.level);
    }

    private static ItemStack findPotionAmplify(ItemStack stack) {
        if (!(stack.getItem() instanceof PotionItem)) {
            return ItemStack.EMPTY;
        }
        Optional optional = ((PotionContents)stack.getComponents().getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).potion();
        if (optional.isEmpty()) {
            return ItemStack.EMPTY;
        }
        String potionName = ((ResourceKey)((Holder)optional.get()).unwrapKey().get()).location().getPath();
        for (ResourceLocation resource : BuiltInRegistries.POTION.keySet()) {
            Optional holder = BuiltInRegistries.POTION.getHolder(ResourceLocation.withDefaultNamespace((String)("strong_" + potionName)));
            if (!holder.isPresent()) continue;
            return PotionContents.createItemStack((Item)stack.getItem(), (Holder)((Holder)holder.get()));
        }
        return ItemStack.EMPTY;
    }

    private static ItemStack handleNeedleStoredItem(ItemStack inputItem, ItemStack resultItem) {
        if (!inputItem.has(DataComponentsRegistry.POSSIBLE_AFFINITIES) || resultItem.has(DataComponentsRegistry.AFFINITY_STORED_ITEM)) {
            return resultItem;
        }
        ItemStack newResultItem = resultItem.copy();
        newResultItem.set(DataComponentsRegistry.AFFINITY_STORED_ITEM, (Object)inputItem.getItemHolder());
        return newResultItem;
    }

    public void resetAlembic() {
        this.boilProgress = 0;
        this.returnStack = ItemStack.EMPTY;
        this.setResultItem(ItemStack.EMPTY);
    }

    public void setResultItem(ItemStack item) {
        this.resultItem = item.copy();
    }

    public ItemStack getResultItem() {
        return this.resultItem.copy();
    }

    public ItemStack getReturnStack() {
        return this.returnStack.copy();
    }

    public ItemStackHandler getItemContainer() {
        return this.itemContainer;
    }

    public boolean hasFuel() {
        return this.fuel > 0;
    }

    private boolean isBoiling() {
        return this.boilProgress > 0;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        NonNullList list = NonNullList.create();
        for (int i = 0; i < 3; ++i) {
            list.add(i, (Object)this.itemContainer.getStackInSlot(i).copy());
        }
        list.add((Object)this.returnStack);
        list.add((Object)this.resultItem);
        ContainerHelper.saveAllItems((CompoundTag)tag, (NonNullList)list, (HolderLookup.Provider)registries);
        tag.putInt("Fuel", this.fuel);
        tag.putInt("BoilProgress", this.boilProgress);
        tag.putInt("BoilProgressTime", this.boilTotalTime);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        int i;
        super.loadAdditional(tag, registries);
        NonNullList list = NonNullList.withSize((int)5, (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)list, (HolderLookup.Provider)registries);
        for (i = 0; i < 3; ++i) {
            this.itemContainer.setStackInSlot(i, (ItemStack)list.get(i));
        }
        this.returnStack = (ItemStack)list.get(i);
        this.setResultItem((ItemStack)list.get(i + 1));
        this.fuel = tag.getInt("Fuel");
        this.boilProgress = tag.getInt("BoilProgress");
        this.boilTotalTime = tag.getInt("BoilProgressTime");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider registries) {
        super.onDataPacket(connection, packet, registries);
    }

    public int getSlots() {
        return 3;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.itemContainer.getStackInSlot(slot).copy();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        ItemStack itemStack = stack.copy();
        return this.itemContainer.insertItem(slot, itemStack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack returnItem;
        ItemStack targetStack = this.itemContainer.getStackInSlot(slot).copy();
        if (targetStack.getCount() > amount) {
            returnItem = targetStack.copy();
            returnItem.setCount(amount);
            targetStack.setCount(targetStack.getCount() - amount);
        } else {
            returnItem = targetStack.copy();
            this.itemContainer.setStackInSlot(slot, ItemStack.EMPTY);
        }
        return returnItem;
    }

    public int getSlotLimit(int slot) {
        return this.itemContainer.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot == 0) {
            return true;
        }
        return stack.getBurnTime(this.recipeType) > 0;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.toxony.alembic");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return new AlembicMenu(id, playerInventory, this, this.data, ContainerLevelAccess.create((Level)player.level(), (BlockPos)this.worldPosition));
    }
}

