/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.blocks.entities;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import xyz.yfrostyf.toxony.ToxonyMain;
import xyz.yfrostyf.toxony.blocks.CopperCrucibleBlock;
import xyz.yfrostyf.toxony.client.gui.block.CopperCrucibleMenu;
import xyz.yfrostyf.toxony.recipes.CrucibleRecipe;
import xyz.yfrostyf.toxony.registries.BlockRegistry;
import xyz.yfrostyf.toxony.registries.RecipeRegistry;

public class CopperCrucibleBlockEntity
extends BlockEntity
implements IItemHandler,
MenuProvider {
    private static final int CONTAINER_SIZE = 2;
    public int litTime = 0;
    public int litDuration = 0;
    public int cookingProgress = 0;
    public int cookingTotalTime = 0;
    public ItemStack resultItem;
    public ItemStackHandler itemContainer;
    private RecipeType<CrucibleRecipe> recipeType;
    protected final ContainerData data = new ContainerData(){

        public int get(int index) {
            switch (index) {
                case 0: {
                    if (CopperCrucibleBlockEntity.this.litDuration > Short.MAX_VALUE) {
                        return Mth.floor((double)((double)CopperCrucibleBlockEntity.this.litTime / (double)CopperCrucibleBlockEntity.this.litDuration * 32767.0));
                    }
                    return CopperCrucibleBlockEntity.this.litTime;
                }
                case 1: {
                    return Math.min(CopperCrucibleBlockEntity.this.litDuration, Short.MAX_VALUE);
                }
                case 2: {
                    return CopperCrucibleBlockEntity.this.cookingProgress;
                }
                case 3: {
                    return CopperCrucibleBlockEntity.this.cookingTotalTime;
                }
            }
            return 0;
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    CopperCrucibleBlockEntity.this.litTime = value;
                    break;
                }
                case 1: {
                    CopperCrucibleBlockEntity.this.litDuration = value;
                    break;
                }
                case 2: {
                    CopperCrucibleBlockEntity.this.cookingProgress = value;
                    break;
                }
                case 3: {
                    CopperCrucibleBlockEntity.this.cookingTotalTime = value;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };

    public CopperCrucibleBlockEntity(final BlockPos pos, BlockState state) {
        super(BlockRegistry.COPPER_CRUCIBLE_ENTITY.get(), pos, state);
        this.resultItem = ItemStack.EMPTY;
        this.itemContainer = new ItemStackHandler(2){

            public int getSlotLimit(int slot) {
                if (slot == 0) {
                    return 1;
                }
                return 64;
            }

            protected void onContentsChanged(int slot) {
                if (CopperCrucibleBlockEntity.this.level != null) {
                    CopperCrucibleBlockEntity.this.level.sendBlockUpdated(pos, CopperCrucibleBlockEntity.this.getBlockState(), CopperCrucibleBlockEntity.this.getBlockState(), 3);
                    CopperCrucibleBlockEntity.this.setChanged();
                }
            }
        };
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlockEntity entity) {
        if (!(entity instanceof CopperCrucibleBlockEntity)) {
            return;
        }
        CopperCrucibleBlockEntity blockEntity = (CopperCrucibleBlockEntity)entity;
        if (blockEntity.isLit() && level.getRandom().nextInt(20) == 0) {
            level.playSound(null, pos, SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 0.6f + level.getRandom().nextFloat(), level.getRandom().nextFloat() * 0.7f + 0.6f);
        }
        if (level.isClientSide()) {
            return;
        }
        ItemStack input = blockEntity.itemContainer.getStackInSlot(0);
        ItemStack fuel = blockEntity.itemContainer.getStackInSlot(1);
        ItemStack result = blockEntity.getResultItem();
        if (!(blockEntity.isLit() || fuel.isEmpty() || blockEntity.getResultItem().isEmpty())) {
            ItemStack extract = blockEntity.itemContainer.extractItem(1, 1, false);
            if (extract.hasCraftingRemainingItem() && blockEntity.itemContainer.getStackInSlot(1).isEmpty()) {
                blockEntity.itemContainer.setStackInSlot(1, extract.getCraftingRemainingItem());
            }
            blockEntity.litDuration = blockEntity.litTime = extract.getBurnTime(blockEntity.recipeType);
        }
        if (blockEntity.isLit()) {
            if (!result.isEmpty()) {
                if (blockEntity.cookingProgress < blockEntity.cookingTotalTime) {
                    blockEntity.cookingProgress = Mth.clamp((int)(blockEntity.cookingProgress + 1), (int)0, (int)blockEntity.cookingTotalTime);
                } else {
                    blockEntity.itemContainer.setStackInSlot(0, blockEntity.getResultItem());
                    blockEntity.resetCrucible();
                }
            }
            --blockEntity.litTime;
        } else {
            blockEntity.cookingProgress = Mth.clamp((int)(blockEntity.cookingProgress - 2), (int)0, (int)blockEntity.cookingTotalTime);
        }
        if (result.isEmpty() && blockEntity.findRecipe().isPresent()) {
            Optional<RecipeHolder<CrucibleRecipe>> recipe = blockEntity.findRecipe();
            blockEntity.setResultItem(((CrucibleRecipe)recipe.get().value()).assemble(new SingleRecipeInput(input), (HolderLookup.Provider)level.registryAccess()));
            blockEntity.cookingTotalTime = ((CrucibleRecipe)recipe.get().value()).getCookTime();
        }
        state = blockEntity.isLit() ? (BlockState)state.setValue((Property)CopperCrucibleBlock.LIT, (Comparable)Boolean.valueOf(true)) : (BlockState)state.setValue((Property)CopperCrucibleBlock.LIT, (Comparable)Boolean.valueOf(false));
    }

    public Optional<RecipeHolder<CrucibleRecipe>> findRecipe() {
        if (this.level == null) {
            return Optional.empty();
        }
        if (this.itemContainer.getStackInSlot(0) == ItemStack.EMPTY) {
            return Optional.empty();
        }
        SingleRecipeInput input = new SingleRecipeInput(this.itemContainer.getStackInSlot(0));
        return this.level.getRecipeManager().getRecipeFor(RecipeRegistry.CRUCIBLE_RECIPE.get(), (RecipeInput)input, this.level);
    }

    public void resetCrucible() {
        this.cookingProgress = 0;
        this.setResultItem(ItemStack.EMPTY);
    }

    public void setResultItem(ItemStack item) {
        this.resultItem = item.copy();
    }

    public boolean hasItemInInventory() {
        return this.getItemContainer().getStackInSlot(0) != ItemStack.EMPTY;
    }

    public ItemStack getResultItem() {
        return this.resultItem.copy();
    }

    public ItemStackHandler getItemContainer() {
        return this.itemContainer;
    }

    public boolean isLit() {
        return this.litTime > 0;
    }

    protected int getBurnDuration(ItemStack fuel) {
        if (fuel.isEmpty()) {
            return 0;
        }
        return fuel.getBurnTime(this.recipeType);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        NonNullList list = NonNullList.create();
        list.add(0, (Object)this.itemContainer.getStackInSlot(0).copy());
        list.add(1, (Object)this.itemContainer.getStackInSlot(1).copy());
        list.addLast((Object)this.resultItem);
        ContainerHelper.saveAllItems((CompoundTag)tag, (NonNullList)list, (HolderLookup.Provider)registries);
        for (ItemStack stack : list) {
            ToxonyMain.LOGGER.debug("[Save]: " + stack.toString());
        }
        tag.putInt("BurnTime", this.litTime);
        tag.putInt("CookTime", this.cookingProgress);
        tag.putInt("CookTimeTotal", this.cookingTotalTime);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        NonNullList list = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)list, (HolderLookup.Provider)registries);
        this.itemContainer.setStackInSlot(0, (ItemStack)list.get(0));
        this.itemContainer.setStackInSlot(1, (ItemStack)list.get(1));
        this.setResultItem((ItemStack)list.getLast());
        for (ItemStack stack : list) {
            ToxonyMain.LOGGER.debug("[Load]: " + stack.toString());
        }
        this.litTime = tag.getInt("BurnTime");
        this.cookingProgress = tag.getInt("CookTime");
        this.cookingTotalTime = tag.getInt("CookTimeTotal");
        this.litDuration = ((ItemStack)list.getLast()).getBurnTime(this.recipeType);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider registries) {
        super.onDataPacket(connection, packet, registries);
    }

    public int getSlots() {
        return 2;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.itemContainer.getStackInSlot(slot).copy();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        ItemStack itemStack = stack.copy();
        return this.itemContainer.insertItem(slot, itemStack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack returnItem;
        ItemStack targetStack = this.itemContainer.getStackInSlot(slot).copy();
        if (targetStack.getCount() > amount) {
            returnItem = targetStack.copy();
            returnItem.setCount(amount);
            targetStack.setCount(targetStack.getCount() - amount);
        } else {
            returnItem = targetStack.copy();
            this.itemContainer.setStackInSlot(slot, ItemStack.EMPTY);
        }
        return returnItem;
    }

    public int getSlotLimit(int slot) {
        return this.itemContainer.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot == 0) {
            return true;
        }
        return stack.getBurnTime(this.recipeType) > 0;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.toxony.copper_crucible");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return new CopperCrucibleMenu(id, playerInventory, this, this.data, ContainerLevelAccess.create((Level)player.level(), (BlockPos)this.worldPosition));
    }
}

