/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.blocks.entities;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.Nullable;
import xyz.yfrostyf.toxony.blocks.MortarPestleBlock;
import xyz.yfrostyf.toxony.client.gui.block.MortarPestleMenu;
import xyz.yfrostyf.toxony.items.BlendItem;
import xyz.yfrostyf.toxony.recipes.MortarPestleRecipe;
import xyz.yfrostyf.toxony.registries.BlockRegistry;
import xyz.yfrostyf.toxony.registries.DataComponentsRegistry;
import xyz.yfrostyf.toxony.registries.RecipeRegistry;

public class MortarPestleBlockEntity
extends BlockEntity
implements IItemHandler,
MenuProvider {
    public static final float DEFAULT_PESTLE_TICK = 20.0f;
    private static final int CONTAINER_SIZE = 4;
    public static final int PESTLE_TOTAL_COUNT = 3;
    public boolean isPestling = false;
    public int pestleCount = 0;
    public int pestleTick = 0;
    public ItemStack resultItem;
    public ItemStackHandler itemContainer;
    protected final ContainerData data = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> {
                    if (MortarPestleBlockEntity.this.isPestling) {
                        yield 1;
                    }
                    yield 0;
                }
                case 1 -> MortarPestleBlockEntity.this.pestleCount;
                case 2 -> MortarPestleBlockEntity.this.pestleTick;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    MortarPestleBlockEntity.this.isPestling = value > 0;
                    break;
                }
                case 1: {
                    MortarPestleBlockEntity.this.pestleCount = value;
                    break;
                }
                case 2: {
                    MortarPestleBlockEntity.this.pestleTick = value;
                }
            }
        }

        public int getCount() {
            return 3;
        }
    };

    public MortarPestleBlockEntity(final BlockPos pos, BlockState state) {
        super(BlockRegistry.MORTAR_PESTLE_ENTITY.get(), pos, state);
        this.resultItem = ItemStack.EMPTY;
        this.itemContainer = new ItemStackHandler(4){

            protected void onContentsChanged(int slot) {
                if (MortarPestleBlockEntity.this.level != null) {
                    MortarPestleBlockEntity.this.level.sendBlockUpdated(pos, MortarPestleBlockEntity.this.getBlockState(), MortarPestleBlockEntity.this.getBlockState(), 3);
                    MortarPestleBlockEntity.this.setChanged();
                }
            }
        };
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlockEntity entity) {
        if (!(entity instanceof MortarPestleBlockEntity)) {
            return;
        }
        MortarPestleBlockEntity blockEntity = (MortarPestleBlockEntity)entity;
        if (blockEntity.pestleTick > 0 && blockEntity.isPestling) {
            --blockEntity.pestleTick;
        }
        if (level.isClientSide()) {
            return;
        }
        if (!(state.getBlock() instanceof MortarPestleBlock)) {
            return;
        }
        if (blockEntity.isPestling && blockEntity.pestleTick > 0) {
            return;
        }
        BlockState blockState = state;
        blockState = blockEntity.pestleCount >= 3 ? (BlockState)blockState.setValue((Property)MortarPestleBlock.INGREDIENTS, (Comparable)Integer.valueOf(5)) : (blockEntity.pestleCount == 2 ? (BlockState)blockState.setValue((Property)MortarPestleBlock.INGREDIENTS, (Comparable)Integer.valueOf(4)) : (blockEntity.pestleCount == 1 ? (BlockState)blockState.setValue((Property)MortarPestleBlock.INGREDIENTS, (Comparable)Integer.valueOf(3)) : (!blockEntity.getResultItem().isEmpty() ? (BlockState)blockState.setValue((Property)MortarPestleBlock.INGREDIENTS, (Comparable)Integer.valueOf(2)) : (blockEntity.hasItemInInventory() ? (BlockState)blockState.setValue((Property)MortarPestleBlock.INGREDIENTS, (Comparable)Integer.valueOf(1)) : (BlockState)blockState.setValue((Property)MortarPestleBlock.INGREDIENTS, (Comparable)Integer.valueOf(0))))));
        level.setBlock(pos, blockState, 2);
    }

    public Optional<RecipeHolder<MortarPestleRecipe>> findRecipe() {
        if (this.level == null) {
            return Optional.empty();
        }
        NonNullList noAirList = NonNullList.create();
        for (int i = 0; i < this.getItemContainer().getSlots(); ++i) {
            ItemStack item = this.getItemContainer().getStackInSlot(i);
            if (item.getItem() == Items.AIR) continue;
            noAirList.add((Object)item);
        }
        RecipeWrapper wrapper = new RecipeWrapper((IItemHandler)new ItemStackHandler(noAirList));
        return this.level.getRecipeManager().getRecipeFor(RecipeRegistry.MORTAR_PESTLE_RECIPE.get(), (RecipeInput)wrapper, this.level);
    }

    public void startPestling() {
        if (this.level == null) {
            return;
        }
        this.pestleTick = 0;
        this.isPestling = true;
        this.setResultItem(this.findRecipe().map(RecipeHolder::value).map(MortarPestleRecipe::getResultItem).orElse(ItemStack.EMPTY));
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
    }

    public void finishPestling(Player player, Level level) {
        ItemStack itemStackInHand = player.getItemInHand(InteractionHand.MAIN_HAND);
        ItemStack useItem = this.findRecipe().map(RecipeHolder::value).get().getUseItem().orElse(ItemStack.EMPTY);
        ArrayList<ItemStack> ingredientsCache = new ArrayList<ItemStack>();
        if (itemStackInHand.getItem() == useItem.getItem() || useItem.isEmpty()) {
            if (level.isClientSide()) {
                return;
            }
            for (int i = 0; i < this.getItemContainer().getSlots(); ++i) {
                ingredientsCache.add(this.getItemContainer().extractItem(i, 1, false));
            }
            if (this.resultItem.getItem() instanceof BlendItem) {
                ArrayList<Holder> stored_items = new ArrayList<Holder>();
                for (ItemStack item : ingredientsCache) {
                    if (!item.has(DataComponentsRegistry.POSSIBLE_AFFINITIES)) continue;
                    stored_items.add(item.getItemHolder());
                }
                this.resultItem.set(DataComponentsRegistry.AFFINITY_STORED_ITEMS, stored_items);
            }
            if (!useItem.isEmpty()) {
                itemStackInHand.consume(1, (LivingEntity)player);
            }
            if (!player.addItem(this.getResultItem())) {
                Block.popResource((Level)this.level, (BlockPos)this.getBlockPos(), (ItemStack)this.getResultItem());
            }
            this.isPestling = false;
            this.pestleCount = 0;
            this.setResultItem(this.findRecipe().map(RecipeHolder::value).map(MortarPestleRecipe::getResultItem).orElse(ItemStack.EMPTY));
            level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        } else {
            Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"message.toxony.mortar.warning", (Object[])new Object[]{Component.translatable((String)useItem.getDescriptionId())}), false);
        }
    }

    public void setResultItem(ItemStack item) {
        this.resultItem = item.copy();
    }

    public boolean hasItemInInventory() {
        for (int i = 0; i < this.getItemContainer().getSlots(); ++i) {
            if (this.getItemContainer().getStackInSlot(i).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ItemStack getResultItem() {
        return this.resultItem.copy();
    }

    public ItemStackHandler getItemContainer() {
        return this.itemContainer;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.isPestling = tag.getBoolean("mortar_pestling");
        this.pestleCount = tag.getInt("mortar_pestle_count");
        this.pestleTick = tag.getInt("mortar_pestle_tick");
        NonNullList list = NonNullList.withSize((int)5, (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)list, (HolderLookup.Provider)registries);
        for (int i = 0; i < 4; ++i) {
            this.itemContainer.setStackInSlot(i, (ItemStack)list.get(i));
        }
        this.setResultItem((ItemStack)list.getLast());
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putBoolean("mortar_pestling", this.isPestling);
        tag.putInt("mortar_pestle_count", this.pestleCount);
        tag.putInt("mortar_pestle_tick", this.pestleTick);
        NonNullList list = NonNullList.create();
        for (int i = 0; i < 4; ++i) {
            list.add(i, (Object)this.itemContainer.getStackInSlot(i).copy());
        }
        list.add(4, (Object)this.resultItem);
        ContainerHelper.saveAllItems((CompoundTag)tag, (NonNullList)list, (HolderLookup.Provider)registries);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider registries) {
        super.onDataPacket(connection, packet, registries);
    }

    public int getSlots() {
        return 4;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.itemContainer.getStackInSlot(slot).copy();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        ItemStack itemStack = stack.copy();
        return this.itemContainer.insertItem(slot, itemStack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack returnItem;
        ItemStack targetStack = this.itemContainer.getStackInSlot(slot).copy();
        if (targetStack.getCount() > amount) {
            returnItem = targetStack.copy();
            returnItem.setCount(amount);
            targetStack.setCount(targetStack.getCount() - amount);
        } else {
            returnItem = targetStack.copy();
            this.itemContainer.setStackInSlot(slot, ItemStack.EMPTY);
        }
        return returnItem;
    }

    public int getSlotLimit(int slot) {
        return this.itemContainer.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.toxony.mortar_pestle");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return new MortarPestleMenu(id, playerInventory, this, this.data, ContainerLevelAccess.create((Level)player.level(), (BlockPos)this.worldPosition));
    }
}

