/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.blocks.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import xyz.yfrostyf.toxony.registries.BlockRegistry;

public class OilPotBlockEntity
extends BlockEntity
implements EntityBlock {
    private int maxDamage;
    private int damage;

    public OilPotBlockEntity(BlockPos pos, BlockState blockState) {
        super(BlockRegistry.OIL_POT_ENTITY.get(), pos, blockState);
        this.maxDamage = 3;
        this.damage = 0;
    }

    public OilPotBlockEntity(BlockPos pos, BlockState blockState, int maxDurability, int damage) {
        super(BlockRegistry.OIL_POT_ENTITY.get(), pos, blockState);
        this.maxDamage = maxDurability;
        this.damage = damage;
    }

    public int getDamage() {
        return this.damage;
    }

    public int getMaxDamage() {
        return this.maxDamage;
    }

    public void setMaxDamage(int maxDamage) {
        this.maxDamage = maxDamage;
    }

    public void setDamage(int damage) {
        this.damage = damage;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.maxDamage = tag.getInt("max_damage");
        this.damage = tag.getInt("damage");
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("max_damage", this.maxDamage);
        tag.putInt("damage", this.damage);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider registries) {
        super.onDataPacket(connection, packet, registries);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new OilPotBlockEntity(pos, state);
    }
}

