/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.blocks.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.Nullable;
import xyz.yfrostyf.toxony.blocks.RedstoneMortarBlock;
import xyz.yfrostyf.toxony.client.gui.block.RedstoneMortarMenu;
import xyz.yfrostyf.toxony.items.BlendItem;
import xyz.yfrostyf.toxony.recipes.MortarPestleRecipe;
import xyz.yfrostyf.toxony.registries.BlockRegistry;
import xyz.yfrostyf.toxony.registries.DataComponentsRegistry;
import xyz.yfrostyf.toxony.registries.RecipeRegistry;

public class RedstoneMortarBlockEntity
extends BlockEntity
implements IItemHandler,
MenuProvider {
    private static final int CONTAINER_SIZE = 6;
    private static final int USE_SLOT = 4;
    private static final int RESULT_SLOT = 5;
    public boolean isPestling = false;
    public int pestleCount = 0;
    public int pestleTick = 0;
    public ItemStack resultItem;
    public ItemStackHandler itemContainer;
    protected final ContainerData data = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> {
                    if (RedstoneMortarBlockEntity.this.isPestling) {
                        yield 1;
                    }
                    yield 0;
                }
                case 1 -> RedstoneMortarBlockEntity.this.pestleCount;
                case 2 -> RedstoneMortarBlockEntity.this.pestleTick;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    RedstoneMortarBlockEntity.this.isPestling = value > 0;
                    break;
                }
                case 1: {
                    RedstoneMortarBlockEntity.this.pestleCount = value;
                    break;
                }
                case 2: {
                    RedstoneMortarBlockEntity.this.pestleTick = value;
                }
            }
        }

        public int getCount() {
            return 3;
        }
    };

    public RedstoneMortarBlockEntity(final BlockPos pos, BlockState state) {
        super(BlockRegistry.REDSTONE_MORTAR_ENTITY.get(), pos, state);
        this.resultItem = ItemStack.EMPTY;
        this.itemContainer = new ItemStackHandler(6){

            protected void onContentsChanged(int slot) {
                if (RedstoneMortarBlockEntity.this.level != null) {
                    RedstoneMortarBlockEntity.this.level.sendBlockUpdated(pos, RedstoneMortarBlockEntity.this.getBlockState(), RedstoneMortarBlockEntity.this.getBlockState(), 3);
                    RedstoneMortarBlockEntity.this.setChanged();
                }
            }
        };
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlockEntity entity) {
        if (!(entity instanceof RedstoneMortarBlockEntity)) {
            return;
        }
        RedstoneMortarBlockEntity blockEntity = (RedstoneMortarBlockEntity)entity;
        if (blockEntity.pestleTick > 0 && blockEntity.isPestling) {
            --blockEntity.pestleTick;
        }
        if (level.isClientSide()) {
            return;
        }
        if (!(state.getBlock() instanceof RedstoneMortarBlock)) {
            return;
        }
        if (blockEntity.isPestling && blockEntity.pestleTick > 0) {
            return;
        }
        BlockState blockState = state;
        blockState = blockEntity.getPestleProgress() >= 0.75f ? (BlockState)blockState.setValue((Property)RedstoneMortarBlock.INGREDIENTS, (Comparable)Integer.valueOf(5)) : (blockEntity.getPestleProgress() >= 0.5f ? (BlockState)blockState.setValue((Property)RedstoneMortarBlock.INGREDIENTS, (Comparable)Integer.valueOf(4)) : (blockEntity.getPestleProgress() >= 0.25f ? (BlockState)blockState.setValue((Property)RedstoneMortarBlock.INGREDIENTS, (Comparable)Integer.valueOf(3)) : (!blockEntity.getResultItem().isEmpty() ? (BlockState)blockState.setValue((Property)RedstoneMortarBlock.INGREDIENTS, (Comparable)Integer.valueOf(2)) : (blockEntity.hasItemInInventory() ? (BlockState)blockState.setValue((Property)RedstoneMortarBlock.INGREDIENTS, (Comparable)Integer.valueOf(1)) : (BlockState)blockState.setValue((Property)RedstoneMortarBlock.INGREDIENTS, (Comparable)Integer.valueOf(0))))));
        level.setBlock(pos, blockState, 2);
    }

    public float getPestleProgress() {
        return (float)this.pestleCount / 5.0f;
    }

    public Optional<RecipeHolder<MortarPestleRecipe>> findRecipe() {
        if (this.level == null) {
            return Optional.empty();
        }
        NonNullList noAirList = NonNullList.create();
        for (int i = 0; i < this.getItemContainer().getSlots() - 2; ++i) {
            ItemStack item = this.getItemContainer().getStackInSlot(i);
            if (item.getItem() == Items.AIR) continue;
            noAirList.add((Object)item);
        }
        RecipeWrapper wrapper = new RecipeWrapper((IItemHandler)new ItemStackHandler(noAirList));
        return this.level.getRecipeManager().getRecipeFor(RecipeRegistry.MORTAR_PESTLE_RECIPE.get(), (RecipeInput)wrapper, this.level);
    }

    public void startPestling() {
        Optional<RecipeHolder<MortarPestleRecipe>> recipe = this.findRecipe();
        if (recipe.isEmpty()) {
            return;
        }
        if (this.getUseItem().getItem() != ((MortarPestleRecipe)recipe.get().value()).getUseItem().orElse(ItemStack.EMPTY).getItem()) {
            return;
        }
        this.pestleTick = 0;
        this.isPestling = true;
        this.setResultItem(((MortarPestleRecipe)recipe.get().value()).getResultItem());
    }

    public void finishPestling(Level level) {
        ItemStack remaining;
        if (level == null) {
            return;
        }
        List<ItemStack> ingredientsCache = this.getIngredients();
        ItemStack resultStack = this.getResultItem();
        if (resultStack.getItem() instanceof BlendItem) {
            ArrayList<Holder> stored_items = new ArrayList<Holder>();
            for (ItemStack item : ingredientsCache) {
                if (!item.has(DataComponentsRegistry.POSSIBLE_AFFINITIES)) continue;
                stored_items.add(item.getItemHolder());
            }
            resultStack.set(DataComponentsRegistry.AFFINITY_STORED_ITEMS, stored_items);
        }
        if (!this.itemContainer.getStackInSlot(4).isEmpty()) {
            this.itemContainer.extractItem(4, 1, false);
        }
        if ((remaining = this.insertItem(5, resultStack, false)) != ItemStack.EMPTY) {
            Block.popResource((Level)this.level, (BlockPos)this.getBlockPos(), (ItemStack)remaining);
        }
        this.resetPestling();
    }

    public void resetPestling() {
        if (this.level == null) {
            return;
        }
        this.isPestling = false;
        this.pestleTick = 0;
        this.pestleCount = 0;
        this.setResultItem(ItemStack.EMPTY);
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
    }

    public boolean hasItemInInventory() {
        for (int i = 0; i < this.getItemContainer().getSlots(); ++i) {
            if (i == 4 || this.getItemContainer().getStackInSlot(i).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public List<ItemStack> getIngredients() {
        ArrayList<ItemStack> ingredientsList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getItemContainer().getSlots() - 2; ++i) {
            ingredientsList.add(this.getItemContainer().extractItem(i, 1, false));
        }
        return ingredientsList;
    }

    public void setResultItem(ItemStack item) {
        this.resultItem = item.copy();
    }

    public ItemStack getResultItem() {
        return this.resultItem.copy();
    }

    public ItemStack getUseItem() {
        return this.itemContainer.getStackInSlot(4).copy();
    }

    public ItemStackHandler getItemContainer() {
        return this.itemContainer;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.isPestling = tag.getBoolean("redstone_mortar_pestling");
        this.pestleCount = tag.getInt("redstone_mortar_pestle_count");
        this.pestleTick = tag.getInt("redstone_mortar_pestle_tick");
        NonNullList list = NonNullList.withSize((int)7, (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)list, (HolderLookup.Provider)registries);
        for (int i = 0; i < 6; ++i) {
            this.itemContainer.setStackInSlot(i, (ItemStack)list.get(i));
        }
        this.setResultItem((ItemStack)list.getLast());
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putBoolean("redstone_mortar_pestling", this.isPestling);
        tag.putInt("redstone_mortar_pestle_count", this.pestleCount);
        tag.putInt("redstone_mortar_pestle_tick", this.pestleTick);
        NonNullList list = NonNullList.create();
        for (int i = 0; i < 6; ++i) {
            list.add(i, (Object)this.itemContainer.getStackInSlot(i).copy());
        }
        list.add(6, (Object)this.resultItem);
        ContainerHelper.saveAllItems((CompoundTag)tag, (NonNullList)list, (HolderLookup.Provider)registries);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider registries) {
        super.onDataPacket(connection, packet, registries);
    }

    public int getSlots() {
        return 6;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.itemContainer.getStackInSlot(slot).copy();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        ItemStack itemStack = stack.copy();
        return this.itemContainer.insertItem(slot, itemStack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack returnItem;
        ItemStack targetStack = this.itemContainer.getStackInSlot(slot).copy();
        if (targetStack.getCount() > amount) {
            returnItem = targetStack.copy();
            returnItem.setCount(amount);
            targetStack.setCount(targetStack.getCount() - amount);
        } else {
            returnItem = targetStack.copy();
            this.itemContainer.setStackInSlot(slot, ItemStack.EMPTY);
        }
        return returnItem;
    }

    public int getSlotLimit(int slot) {
        return this.itemContainer.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.toxony.redstone_mortar");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return new RedstoneMortarMenu(id, playerInventory, this, this.data, ContainerLevelAccess.create((Level)player.level(), (BlockPos)this.worldPosition));
    }
}

