/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.blocks.plants;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.EventHooks;
import xyz.yfrostyf.toxony.ToxonyConfig;
import xyz.yfrostyf.toxony.api.affinity.Affinity;
import xyz.yfrostyf.toxony.api.affinity.AffinityBlockPair;
import xyz.yfrostyf.toxony.api.tox.ToxData;
import xyz.yfrostyf.toxony.api.util.AffinityUtil;
import xyz.yfrostyf.toxony.blocks.PoisonFarmBlock;
import xyz.yfrostyf.toxony.registries.BlockRegistry;
import xyz.yfrostyf.toxony.registries.DataAttachmentRegistry;
import xyz.yfrostyf.toxony.registries.DataComponentsRegistry;
import xyz.yfrostyf.toxony.registries.ItemRegistry;

public class PoisonCropBlock
extends CropBlock
implements BonemealableBlock {
    public static final MapCodec<PoisonCropBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PoisonCropBlock.propertiesCodec(), (App)BuiltInRegistries.ITEM.holderByNameCodec().fieldOf("grown_item").forGetter(PoisonCropBlock::getGrownItem), (App)MobEffect.CODEC.listOf().fieldOf("effects").forGetter(PoisonCropBlock::getContactEffects), (App)AffinityBlockPair.CODEC.optionalFieldOf("evolved_plant").forGetter(PoisonCropBlock::getEvolvedPlant)).apply((Applicative)instance, PoisonCropBlock::new));
    public static final int MAX_AGE = 5;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_5;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0)};
    protected final Supplier<Holder<Item>> grownItem;
    protected final List<Holder<MobEffect>> contactEffects;
    protected final Supplier<Optional<AffinityBlockPair>> evolvedPlant;

    public PoisonCropBlock(BlockBehaviour.Properties properties, Holder<Item> grownItem, List<Holder<MobEffect>> contactEffects, Optional<AffinityBlockPair> evolvedPlant) {
        super(properties);
        this.grownItem = () -> grownItem;
        this.contactEffects = contactEffects;
        this.evolvedPlant = () -> evolvedPlant;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public PoisonCropBlock(BlockBehaviour.Properties properties, Supplier<Holder<Item>> grownItem, List<Holder<MobEffect>> contactEffects, Supplier<Optional<AffinityBlockPair>> evolvedPlant) {
        super(properties);
        this.grownItem = grownItem;
        this.contactEffects = contactEffects;
        this.evolvedPlant = evolvedPlant;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public MapCodec<? extends PoisonCropBlock> codec() {
        return CODEC;
    }

    public List<Holder<MobEffect>> getContactEffects() {
        return this.contactEffects;
    }

    public Optional<AffinityBlockPair> getEvolvedPlant() {
        return this.evolvedPlant.get();
    }

    public Holder<Item> getGrownItem() {
        return this.grownItem.get();
    }

    protected ItemInteractionResult tryTransformEvolved(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player) {
        if (!stack.has(DataComponentsRegistry.POSSIBLE_AFFINITIES) || stack.getItem().equals(this.grownItem.get().value())) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ToxData plyToxData = (ToxData)player.getData(DataAttachmentRegistry.TOX_DATA);
        if (!plyToxData.knowsIngredient(stack) || !plyToxData.knowsIngredient(this.getGrownItem())) {
            if (!level.isClientSide()) {
                return ItemInteractionResult.FAIL;
            }
            Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"message.toxony.graft.unknown"), false);
            return ItemInteractionResult.CONSUME;
        }
        if (this.getEvolvedPlant().isPresent()) {
            Holder<Affinity> affinityHolder = this.getEvolvedPlant().get().affinity();
            Holder<Block> blockHolder = this.getEvolvedPlant().get().block();
            Object object = blockHolder.value();
            if (object instanceof PoisonCropBlock) {
                PoisonCropBlock poisonCropBlock = (PoisonCropBlock)((Object)object);
                if (((Affinity)affinityHolder.value()).equals(AffinityUtil.readAffinityFromIngredientMap(stack, level))) {
                    if (!level.isClientSide()) {
                        stack.consume(1, (LivingEntity)player);
                        level.setBlock(pos, poisonCropBlock.defaultBlockState(), 3);
                    } else {
                        Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"message.toxony.graft.success"), false);
                    }
                    return ItemInteractionResult.SUCCESS;
                }
                if (!level.isClientSide()) {
                    stack.consume(1, (LivingEntity)player);
                    level.destroyBlock(pos, false);
                    return ItemInteractionResult.FAIL;
                }
                Minecraft.getInstance().gui.setOverlayMessage((Component)Component.translatable((String)"message.toxony.graft.fail"), false);
                return ItemInteractionResult.CONSUME;
            }
            throw new ClassCastException("This block contains incorrect data within its possible evolved blocks.");
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack graftStack;
        int age = this.getAge(state);
        ItemStack itemStack = graftStack = player.getMainHandItem().has(DataComponentsRegistry.POSSIBLE_AFFINITIES) ? player.getMainHandItem() : player.getOffhandItem();
        if (graftStack.has(DataComponentsRegistry.POSSIBLE_AFFINITIES) && age <= 1) {
            return this.tryTransformEvolved(stack, state, level, pos, player);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        float f;
        int age;
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (level.getRawBrightness(pos, 0) >= 9 && (age = this.getAge(state)) < this.getMaxAge() && CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(28.0f / (f = PoisonCropBlock.getGrowthSpeed(state, (BlockGetter)level, pos))) + 1) == 0 ? 1 : 0) != 0)) {
            level.setBlock(pos, this.getStateForAge(age + 1), 2);
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[this.getAge(state)];
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.getBlock() instanceof PoisonFarmBlock;
    }

    protected IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 5;
    }

    public int getAge(BlockState state) {
        return (Integer)state.getValue((Property)this.getAgeProperty());
    }

    public BlockState getStateForAge(int age) {
        return (BlockState)this.defaultBlockState().setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return !this.isMaxAge(state);
    }

    public void growCrops(Level level, BlockPos pos, BlockState state) {
        int maxAge;
        int inc = this.getBonemealAgeIncrease(level);
        int age = this.getAge(state) + inc;
        if (age > (maxAge = this.getMaxAge())) {
            age = maxAge;
        }
        level.setBlock(pos, this.getStateForAge(age), 2);
    }

    protected static float getGrowthSpeed(BlockState blockState, BlockGetter blockGetter, BlockPos pos) {
        boolean flag1;
        Block block = blockState.getBlock();
        float f = 1.0f;
        BlockPos blockpos = pos.below();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState blockstate = blockGetter.getBlockState(blockpos.offset(i, 0, j));
                TriState soilDecision = blockstate.canSustainPlant(blockGetter, blockpos.offset(i, 0, j), Direction.UP, blockState);
                if (soilDecision.isDefault() ? blockstate.getBlock() instanceof FarmBlock : soilDecision.isTrue()) {
                    f1 = 1.0f;
                    if (blockstate.isFertile(blockGetter, pos.offset(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pos.north();
        BlockPos blockpos2 = pos.south();
        BlockPos blockpos3 = pos.west();
        BlockPos blockpos4 = pos.east();
        boolean flag = blockGetter.getBlockState(blockpos3).is(block) || blockGetter.getBlockState(blockpos4).is(block);
        boolean bl = flag1 = blockGetter.getBlockState(blockpos1).is(block) || blockGetter.getBlockState(blockpos2).is(block);
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = blockGetter.getBlockState(blockpos3.north()).is(block) || blockGetter.getBlockState(blockpos4.north()).is(block) || blockGetter.getBlockState(blockpos4.south()).is(block) || blockGetter.getBlockState(blockpos3.south()).is(block);
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f * ((Double)ToxonyConfig.PLANT_GROWTH_MULT.get()).floatValue();
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState belowBlockState = level.getBlockState(blockpos);
        TriState soilDecision = belowBlockState.canSustainPlant((BlockGetter)level, blockpos, Direction.UP, state);
        return soilDecision.isDefault() && belowBlockState.getBlock() instanceof PoisonFarmBlock;
    }

    public static boolean hasSufficientLight(LevelReader level, BlockPos pos) {
        return level.getRawBrightness(pos, 0) >= 8;
    }

    protected void effectOnContact(LivingEntity livingEntity, BlockState state) {
        for (Holder<MobEffect> effect : this.contactEffects) {
            if (!this.isMaxAge(state)) {
                livingEntity.addEffect(new MobEffectInstance(effect, 300, 0));
                continue;
            }
            livingEntity.addEffect(new MobEffectInstance(effect, 200, 1));
        }
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof Ravager && EventHooks.canEntityGrief((Level)level, (Entity)entity)) {
            level.destroyBlock(pos, true, entity);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!level.isClientSide && entity.xOld != entity.getX() || entity.zOld != entity.getZ()) {
                double d0 = Math.abs(entity.getX() - entity.xOld);
                double d1 = Math.abs(entity.getZ() - entity.zOld);
                if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                    this.effectOnContact(livingEntity, state);
                }
            }
        }
        super.entityInside(state, level, pos, entity);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        if (state.is(BlockRegistry.OCELOT_MINT)) {
            return ((Item)ItemRegistry.OCELOT_MINT_SEEDS.get()).getDefaultInstance();
        }
        if (state.is(BlockRegistry.COLDSNAP)) {
            return ((Item)ItemRegistry.COLDSNAP_SEEDS.get()).getDefaultInstance();
        }
        if (state.is(BlockRegistry.NIGHTSHADE)) {
            return ((Item)ItemRegistry.NIGHTSHADE_SEEDS.get()).getDefaultInstance();
        }
        if (state.is(BlockRegistry.WATER_HEMLOCK)) {
            return ((Item)ItemRegistry.WATER_HEMLOCK_SEEDS.get()).getDefaultInstance();
        }
        if (state.is(BlockRegistry.BLOODROOT)) {
            return ((Item)ItemRegistry.BLOODROOT_FUNGUS.get()).getDefaultInstance();
        }
        if (state.is(BlockRegistry.SNOW_MINT)) {
            return ((Item)ItemRegistry.SNOW_MINT_SEEDS.get()).getDefaultInstance();
        }
        if (state.is(BlockRegistry.WHIRLSNAP)) {
            return ((Item)ItemRegistry.WHIRLSNAP_SEEDS.get()).getDefaultInstance();
        }
        if (state.is(BlockRegistry.SUNSPOT)) {
            return ((Item)ItemRegistry.SUNSPOT_SEEDS.get()).getDefaultInstance();
        }
        if (state.is(BlockRegistry.MOONLIGHT_HEMLOCK)) {
            return ((Item)ItemRegistry.MOONLIGHT_HEMLOCK_SEEDS.get()).getDefaultInstance();
        }
        if (state.is(BlockRegistry.WARPROOT)) {
            return ((Item)ItemRegistry.WARPROOT_FUNGUS.get()).getDefaultInstance();
        }
        return ((Item)ItemRegistry.OCELOT_MINT_SEEDS.get()).getDefaultInstance();
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return !this.isMaxAge(state);
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    protected int getBonemealAgeIncrease(Level level) {
        return Mth.nextInt((RandomSource)level.random, (int)1, (int)1);
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.growCrops((Level)level, pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }
}

