/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.blocks.plants;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import xyz.yfrostyf.toxony.blocks.plants.WildPoisonCropBlock;
import xyz.yfrostyf.toxony.registries.ItemRegistry;

public class WildOcelotMintBlock
extends WildPoisonCropBlock {
    public WildOcelotMintBlock(BlockBehaviour.Properties properties, List<Holder<MobEffect>> contactEffects) {
        super(properties, contactEffects);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    @Override
    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity.getType() != EntityType.OCELOT && entity.getType() != EntityType.BEE) {
                entity.makeStuckInBlock(state, new Vec3((double)0.8f, 0.75, (double)0.8f));
                if (!(level.isClientSide || (Integer)state.getValue((Property)AGE) <= 0 || entity.xOld == entity.getX() && entity.zOld == entity.getZ())) {
                    double d0 = Math.abs(entity.getX() - entity.xOld);
                    double d1 = Math.abs(entity.getZ() - entity.zOld);
                    if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                        livingEntity.addEffect(new MobEffectInstance(MobEffects.POISON, 400, 0));
                    }
                }
            }
        }
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return ((Item)ItemRegistry.WILD_OCELOT_MINT.get()).getDefaultInstance();
    }
}

