/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.blocks.plants;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import xyz.yfrostyf.toxony.registries.BlockRegistry;
import xyz.yfrostyf.toxony.registries.ItemRegistry;

public class WildPoisonCropBlock
extends BushBlock
implements BonemealableBlock {
    public static final MapCodec<WildPoisonCropBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WildPoisonCropBlock.propertiesCodec(), (App)MobEffect.CODEC.listOf().fieldOf("effects").forGetter(WildPoisonCropBlock::getContactEffects)).apply((Applicative)instance, WildPoisonCropBlock::new));
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    private static final VoxelShape MID_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    private static final VoxelShape FULL_GROWTH_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0);
    protected final List<Holder<MobEffect>> contactEffects;

    public WildPoisonCropBlock(BlockBehaviour.Properties properties, List<Holder<MobEffect>> contactEffects) {
        super(properties);
        this.contactEffects = contactEffects;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public MapCodec<WildPoisonCropBlock> codec() {
        return CODEC;
    }

    public List<Holder<MobEffect>> getContactEffects() {
        return this.contactEffects;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if ((Integer)state.getValue((Property)AGE) < 3) {
            return MID_SHAPE;
        }
        return (Integer)state.getValue((Property)AGE) < 3 ? FULL_GROWTH_SHAPE : super.getShape(state, level, pos, context);
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is(BlockTags.DIRT) || state.is(BlockTags.MUSHROOM_GROW_BLOCK) || state.getBlock() instanceof FarmBlock || state.is(Blocks.SOUL_SAND) || state.is(Blocks.SOUL_SOIL) || state.is(Blocks.NETHERRACK);
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 3;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int i = (Integer)state.getValue((Property)AGE);
        if (i < 3 && level.getRawBrightness(pos.above(), 0) >= 9 && CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (random.nextInt(5) == 0 ? 1 : 0) != 0)) {
            BlockState blockstate = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            level.setBlock(pos, blockstate, 2);
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)blockstate));
        }
    }

    protected void effectOnContact(LivingEntity livingEntity, BlockState state) {
        for (Holder<MobEffect> effect : this.contactEffects) {
            livingEntity.addEffect(new MobEffectInstance(effect, 400, 0));
        }
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity.getType() != EntityType.BEE) {
                entity.makeStuckInBlock(state, new Vec3((double)0.8f, 0.75, (double)0.8f));
                if (!(level.isClientSide || (Integer)state.getValue((Property)AGE) <= 0 || entity.xOld == entity.getX() && entity.zOld == entity.getZ())) {
                    double d0 = Math.abs(entity.getX() - entity.xOld);
                    double d1 = Math.abs(entity.getZ() - entity.zOld);
                    if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                        this.effectOnContact(livingEntity, state);
                    }
                }
            }
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return (Integer)state.getValue((Property)AGE) != 3 && stack.is(Items.BONE_MEAL) ? ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION : super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 3;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        int i = Math.min(3, (Integer)state.getValue((Property)AGE) + 1);
        level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        if (state.is(BlockRegistry.WILD_COLDSNAP)) {
            return ((Item)ItemRegistry.WILD_COLDSNAP.get()).getDefaultInstance();
        }
        if (state.is(BlockRegistry.WILD_NIGHTSHADE)) {
            return ((Item)ItemRegistry.WILD_NIGHTSHADE.get()).getDefaultInstance();
        }
        if (state.is(BlockRegistry.WILD_WATER_HEMLOCK)) {
            return ((Item)ItemRegistry.WILD_WATER_HEMLOCK.get()).getDefaultInstance();
        }
        if (state.is(BlockRegistry.WILD_BLOODROOT)) {
            return ((Item)ItemRegistry.WILD_BLOODROOT.get()).getDefaultInstance();
        }
        return ((Item)ItemRegistry.WILD_OCELOT_MINT.get()).getDefaultInstance();
    }
}

