/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.client;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.common.asm.enumextension.EnumProxy;
import net.neoforged.neoforge.client.IArmPoseTransformer;
import xyz.yfrostyf.toxony.items.weapons.CycleBowItem;
import xyz.yfrostyf.toxony.items.weapons.FlailItem;
import xyz.yfrostyf.toxony.items.weapons.FlintlockItem;

@OnlyIn(value=Dist.CLIENT)
public class ToxonyArmPoses {
    public static final EnumProxy<HumanoidModel.ArmPose> ONE_HAND_CROSSBOW_ENUM_PROXY = new EnumProxy(HumanoidModel.ArmPose.class, new Object[]{false, OneHandCrossbowArmPose.INSTANCE});
    public static final EnumProxy<HumanoidModel.ArmPose> ONE_HAND_PISTOL_ENUM_PROXY = new EnumProxy(HumanoidModel.ArmPose.class, new Object[]{false, OneHandedPistolArmPose.INSTANCE});
    public static final EnumProxy<HumanoidModel.ArmPose> FLAIL_ENUM_PROXY = new EnumProxy(HumanoidModel.ArmPose.class, new Object[]{false, FlailArmPose.INSTANCE});

    public static class OneHandCrossbowArmPose
    implements IArmPoseTransformer {
        public static final IArmPoseTransformer INSTANCE = new OneHandCrossbowArmPose();

        public void applyTransform(HumanoidModel<?> model, LivingEntity entity, HumanoidArm arm) {
            boolean isRightHanded = arm == HumanoidArm.RIGHT;
            ItemStack stack = entity.getItemInHand(isRightHanded ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
            if (CycleBowItem.isLoaded(stack)) {
                ModelPart focusHandPart = isRightHanded ? model.rightArm : model.leftArm;
                focusHandPart.yRot = (isRightHanded ? -0.3f : 0.3f) + model.head.yRot;
                focusHandPart.xRot = -1.5707964f + model.head.xRot + 0.1f;
            }
        }
    }

    public static class OneHandedPistolArmPose
    implements IArmPoseTransformer {
        public static final IArmPoseTransformer INSTANCE = new OneHandedPistolArmPose();

        public void applyTransform(HumanoidModel<?> model, LivingEntity entity, HumanoidArm arm) {
            ModelPart otherHandPart;
            boolean isRightHanded = arm == HumanoidArm.RIGHT;
            ModelPart usingHandPart = isRightHanded ? model.rightArm : model.leftArm;
            ModelPart modelPart = otherHandPart = isRightHanded ? model.leftArm : model.rightArm;
            if (entity.isUsingItem()) {
                usingHandPart.yRot = (isRightHanded ? -0.1f : 0.1f) + model.head.yRot;
                usingHandPart.xRot = -2.0943952f + model.head.xRot + 0.1f;
                if (FlintlockItem.isDuelWielding(entity)) {
                    otherHandPart.yRot = (isRightHanded ? 0.1f : -0.1f) + model.head.yRot;
                    otherHandPart.xRot = -1.5707964f + model.head.xRot + 0.1f;
                }
                usingHandPart.z += 2.0f;
            } else {
                usingHandPart.yRot = (isRightHanded ? -0.1f : 0.1f) + model.head.yRot;
                usingHandPart.xRot = -1.5707964f + model.head.xRot + 0.1f;
                if (FlintlockItem.isDuelWielding(entity)) {
                    otherHandPart.yRot = (isRightHanded ? 0.1f : -0.1f) + model.head.yRot;
                    otherHandPart.xRot = -1.5707964f + model.head.xRot + 0.1f;
                }
            }
        }
    }

    public static class FlailArmPose
    implements IArmPoseTransformer {
        public static final IArmPoseTransformer INSTANCE = new FlailArmPose();

        public void applyTransform(HumanoidModel<?> model, LivingEntity entity, HumanoidArm arm) {
            Player player;
            boolean isRightHanded;
            boolean bl = isRightHanded = arm == HumanoidArm.RIGHT;
            if (entity instanceof Player && FlailItem.isUsingFlail((LivingEntity)(player = (Player)entity))) {
                ModelPart focusHandPart = isRightHanded ? model.rightArm : model.leftArm;
                focusHandPart.xRot = focusHandPart.xRot * 0.5f - 2.670354f;
                focusHandPart.yRot = focusHandPart.yRot * 0.5f + 0.31415927f;
            }
        }
    }
}

