/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.client.events.subscribers;

import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import xyz.yfrostyf.toxony.items.BoltCartridgeItem;
import xyz.yfrostyf.toxony.items.PotionFlaskItem;
import xyz.yfrostyf.toxony.items.ToxScalpelItem;
import xyz.yfrostyf.toxony.items.weapons.CycleBowItem;
import xyz.yfrostyf.toxony.items.weapons.FlailItem;
import xyz.yfrostyf.toxony.items.weapons.FlintlockItem;
import xyz.yfrostyf.toxony.items.weapons.WitchingBladeItem;
import xyz.yfrostyf.toxony.registries.ItemRegistry;

@EventBusSubscriber(modid="toxony", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ItemPropertiesEvents {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)ItemRegistry.WITCHING_BLADE.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"active"), (stack, level, player, seed) -> WitchingBladeItem.isActive(stack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ItemRegistry.LETHAL_DOSE.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"active"), (stack, level, player, seed) -> ToxScalpelItem.isActive(stack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ItemRegistry.CYCLEBOW.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"loaded"), (stack, level, player, seed) -> CycleBowItem.getLoadedShots(stack));
            ItemProperties.register((Item)((Item)ItemRegistry.FLINTLOCK.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"loaded"), (stack, level, player, seed) -> FlintlockItem.isLoaded(stack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ItemRegistry.BOLT_CARTRIDGE.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"loaded"), (stack, level, player, seed) -> BoltCartridgeItem.isLoaded(stack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ItemRegistry.FLAIL.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"spin"), (stack, level, player, seed) -> {
                if (player == null) {
                    return 0.0f;
                }
                return player.getUseItem() == stack && FlailItem.isUsingFlail(player) ? 1.0f : 0.0f;
            });
            ItemProperties.register((Item)((Item)ItemRegistry.FLAIL.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"thrown"), (stack, level, player, seed) -> {
                if (player == null) {
                    return 0.0f;
                }
                return player.getUseItem() == stack && FlailItem.isFlailThrown(player) ? 1.0f : 0.0f;
            });
            ItemProperties.register((Item)((Item)ItemRegistry.POTION_FLASK.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"uses"), (stack, level, player, seed) -> PotionFlaskItem.isFull(stack));
            ItemProperties.register((Item)((Item)ItemRegistry.TOXIN_FLASK.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"uses"), (stack, level, player, seed) -> PotionFlaskItem.isFull(stack));
        });
    }
}

