/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.client.events.subscribers;

import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.world.entity.EntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import xyz.yfrostyf.toxony.client.models.entities.GuidedSpiritEntityModel;
import xyz.yfrostyf.toxony.client.models.items.FlailBallEntityModel;
import xyz.yfrostyf.toxony.client.models.items.HunterArmorEntityModel;
import xyz.yfrostyf.toxony.client.models.items.PlagueDoctorArmorEntityModel;
import xyz.yfrostyf.toxony.client.models.items.PlaguebringerArmorEntityModel;
import xyz.yfrostyf.toxony.client.models.items.ProfessionalHunterArmorEntityModel;
import xyz.yfrostyf.toxony.client.renderers.MortarPestleRenderer;
import xyz.yfrostyf.toxony.client.renderers.entities.BoltRenderer;
import xyz.yfrostyf.toxony.client.renderers.entities.FlailBallRenderer;
import xyz.yfrostyf.toxony.client.renderers.entities.GuidedSpiritRenderer;
import xyz.yfrostyf.toxony.registries.BlockRegistry;
import xyz.yfrostyf.toxony.registries.EntityRegistry;

@EventBusSubscriber(modid="toxony", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class RenderRegisterEvents {
    @SubscribeEvent
    public static void onRegisterEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(MortarPestleRenderer.LAYER_LOCATION, MortarPestleRenderer::newModelLayer);
        event.registerLayerDefinition(PlagueDoctorArmorEntityModel.LAYER_LOCATION, PlagueDoctorArmorEntityModel::createBodyLayer);
        event.registerLayerDefinition(PlaguebringerArmorEntityModel.LAYER_LOCATION, PlaguebringerArmorEntityModel::createBodyLayer);
        event.registerLayerDefinition(HunterArmorEntityModel.LAYER_LOCATION, HunterArmorEntityModel::createBodyLayer);
        event.registerLayerDefinition(ProfessionalHunterArmorEntityModel.LAYER_LOCATION, ProfessionalHunterArmorEntityModel::createBodyLayer);
        event.registerLayerDefinition(FlailBallEntityModel.LAYER_LOCATION, FlailBallEntityModel::createBodyLayer);
        event.registerLayerDefinition(GuidedSpiritEntityModel.LAYER_LOCATION, GuidedSpiritEntityModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void onEntityRendererRegister(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)EntityRegistry.OIL_POT.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.BOLT.get(), BoltRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.FLAIL_BALL.get(), FlailBallRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.FLINTLOCK_BALL.get(), context -> new ThrownItemRenderer(context, 0.4f, true));
        event.registerEntityRenderer((EntityType)EntityRegistry.TOXIC_CAKE_PROJECTILE.get(), context -> new ThrownItemRenderer(context, 0.4f, false));
        event.registerEntityRenderer((EntityType)EntityRegistry.GUIDED_SPIRIT.get(), GuidedSpiritRenderer::new);
        event.registerBlockEntityRenderer(BlockRegistry.MORTAR_PESTLE_ENTITY.get(), MortarPestleRenderer::new);
    }
}

