/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.client.gui;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.fml.ModList;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import xyz.yfrostyf.toxony.api.tox.ToxData;
import xyz.yfrostyf.toxony.api.util.GraphicUtil;
import xyz.yfrostyf.toxony.registries.DataAttachmentRegistry;
import xyz.yfrostyf.toxony.registries.ItemRegistry;

public class MobToxBarOverlay
implements LayeredDraw.Layer {
    private static final ResourceLocation BACKGROUND_BAR = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"toxbar/background_bar");
    private static final ResourceLocation TOLERANCE_BAR = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"toxbar/tolerance_bar");
    private static final ResourceLocation TOXIN_BAR = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"toxbar/toxin_bar");
    private static final ResourceLocation SKULL_POINTER = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"toxbar/skull_pointer");
    private static final ResourceLocation SKULL_POINTER_RED = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"toxbar/skull_pointer_red");
    private static final ResourceLocation COMPLETED_MUTAGEN = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"toxbar/completed_mutagen");
    public static final int BAR_WIDTH = 62;
    public static final int BAR_HEIGHT = 5;
    public static final int SKULL_WIDTH = 9;
    public static final int SKULL_HEIGHT = 12;
    public static final int COMPLETED_WIDTH = 62;
    public static final int COMPLETED_HEIGHT = 119;

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        boolean deathState;
        float thresholdGoal;
        float tolerance;
        float tox;
        LocalPlayer player = Minecraft.getInstance().player;
        Entity pickedEntity = Minecraft.getInstance().crosshairPickEntity;
        if (player == null) {
            return;
        }
        if (Minecraft.getInstance().options.hideGui) {
            return;
        }
        if (player.isSpectator()) {
            return;
        }
        if (!MobToxBarOverlay.isToxGaugeOnPlayer((Player)player) || !player.isHolding((Item)ItemRegistry.MAGNIFYING_GLASS.get())) {
            return;
        }
        if (pickedEntity == null) {
            return;
        }
        if (!(pickedEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)pickedEntity;
        if (!livingEntity.hasData(DataAttachmentRegistry.TOX_DATA) && !livingEntity.hasData(DataAttachmentRegistry.MOB_TOXIN)) {
            return;
        }
        if (livingEntity.hasData(DataAttachmentRegistry.TOX_DATA)) {
            ToxData toxData = (ToxData)livingEntity.getData(DataAttachmentRegistry.TOX_DATA);
            tox = toxData.getTox();
            tolerance = toxData.getTolerance();
            thresholdGoal = toxData.getThresholdTolGoal();
            deathState = toxData.getDeathState();
        } else {
            tox = ((Float)livingEntity.getData(DataAttachmentRegistry.MOB_TOXIN)).floatValue();
            tolerance = livingEntity.getMaxHealth();
            thresholdGoal = livingEntity.getMaxHealth();
            deathState = false;
        }
        int toxBarWidth = Mth.floor((float)(60.0f * Math.min(tox / thresholdGoal, 1.0f)));
        int tolBarWidth = Mth.floor((float)(60.0f * Math.min(tolerance / thresholdGoal, 1.0f)));
        int posX = guiGraphics.guiWidth() / 2 - 31 - 1;
        int posY = guiGraphics.guiHeight() / 2 + 14;
        if (livingEntity.hasData(DataAttachmentRegistry.MOB_TOXIN) && (double)tox > livingEntity.getAttributeBaseValue(Attributes.MAX_HEALTH)) {
            float scaleText = 0.67f;
            Font font = Minecraft.getInstance().font;
            Objects.requireNonNull(font);
            int yOffsetAmount = Mth.ceil((float)(9.0f * scaleText));
            guiGraphics.blitSprite(COMPLETED_MUTAGEN, 62, 119, 0, 0, posX, posY - 6, 62, 119);
            MutableComponent textComponent = Component.translatable((String)"mutageninfo.toxony.mob_mutagen").withStyle(Style.EMPTY.withColor(13548929));
            List formatted = font.split((FormattedText)textComponent, 78);
            int yOffset = 0;
            for (FormattedCharSequence line : formatted) {
                float f = posX + 5;
                float f2 = posY;
                Objects.requireNonNull(font);
                GraphicUtil.drawStringWithScale(guiGraphics, font, line, f, f2 + 9.0f / 2.0f + (float)yOffset + 34.0f, scaleText, 0, false);
                yOffset += yOffsetAmount;
            }
        } else {
            guiGraphics.blitSprite(BACKGROUND_BAR, 62, 5, 0, 0, posX, posY, 62, 5);
            guiGraphics.blitSprite(TOLERANCE_BAR, tolBarWidth, 5, 0, 0, posX + 1, posY, tolBarWidth, 5);
            guiGraphics.blitSprite(TOXIN_BAR, toxBarWidth, 5, 0, 0, posX + 1, posY, toxBarWidth, 5);
            guiGraphics.blitSprite(deathState ? SKULL_POINTER_RED : SKULL_POINTER, 9, 12, 0, 0, Math.clamp((long)(posX + toxBarWidth - 4), posX - 2, posX + 62 - 2), posY + 1, 9, 12);
        }
    }

    private static boolean isToxGaugeOnPlayer(Player player) {
        boolean isHolding = player.isHolding((Item)ItemRegistry.TOX_GAUGE.get());
        boolean isInCurios = false;
        if (ModList.get().isLoaded("curios") && CuriosApi.getCuriosInventory((LivingEntity)Minecraft.getInstance().player).isPresent()) {
            isInCurios = ((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)Minecraft.getInstance().player).get()).isEquipped((Item)ItemRegistry.TOX_GAUGE.get());
        }
        return isHolding || isInCurios;
    }
}

