/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import xyz.yfrostyf.toxony.api.client.ClientToxData;
import xyz.yfrostyf.toxony.api.tox.ToxData;
import xyz.yfrostyf.toxony.api.util.GraphicUtil;

public class MutagenInfoScreen
extends Screen {
    private static final ResourceLocation IMAGE = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"textures/gui/mutagen_info.png");
    private static final ResourceLocation IMAGE_PANEL = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"mutageninfo/mutagen_panel");
    private static final ResourceLocation IMAGE_TOXIN = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"mutageninfo/toxin");
    private static final int IMAGE_WIDTH = 256;
    private static final int IMAGE_HEIGHT = 256;
    private static final int IMAGE_PANEL_WIDTH = 62;
    private static final int IMAGE_PANEL_HEIGHT = 149;
    private static final int IMAGE_TOXIN_WIDTH = 249;
    private static final int IMAGE_TOXIN_HEIGHT = 31;
    MobEffectTextureManager effectTextureManager;
    private Font font;
    private ToxData toxData;

    public MutagenInfoScreen() {
        super((Component)Component.empty());
        this.minecraft = Minecraft.getInstance();
        this.font = Minecraft.getInstance().font;
        this.toxData = ClientToxData.getToxData();
        this.effectTextureManager = Minecraft.getInstance().getMobEffectTextures();
    }

    public void openScreen() {
        if (this.minecraft == null) {
            return;
        }
        this.minecraft.setScreen((Screen)this);
    }

    protected void init() {
        super.init();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == Minecraft.getInstance().options.keyInventory.getKey().getValue()) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int backgroundPosX = (this.width - 256) / 2;
        int backgroundPosY = (this.height - 256) / 2;
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.blit(IMAGE, backgroundPosX, backgroundPosY, 0, 0, 256, 256);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int backgroundPosX = (this.width - 256) / 2;
        int backgroundPosY = (this.height - 256) / 2;
        if (this.toxData.getMutagens().isEmpty()) {
            this.renderNoMutagens(guiGraphics, mouseX, mouseY, partialTick);
        } else {
            this.renderMutagens(guiGraphics, mouseX, mouseY, partialTick);
        }
        float progress = Math.clamp(this.toxData.getTox() / this.toxData.getThresholdTolGoal(), 0.0f, 1.0f);
        guiGraphics.blitSprite(IMAGE_TOXIN, 249, 31, 0, 0, backgroundPosX + 4, backgroundPosY + 201, Mth.floor((float)(249.0f * progress)), 31);
        guiGraphics.drawString(this.font, (int)this.toxData.getTox() + " | " + (int)this.toxData.getThresholdTolGoal(), backgroundPosX - 10 + 124, backgroundPosY + 198 + 15, 10813295, false);
    }

    public void renderNoMutagens(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int maxLineWidth = 100;
        int backgroundPosX = (this.width - 256) / 2;
        int backgroundPosY = (this.height - 256) / 2;
        List charSeqLines = this.font.split((FormattedText)Component.translatable((String)"mutageninfo.toxony.empty").withStyle(Style.EMPTY.withColor(13521447)), maxLineWidth);
        int yOffset = 0;
        for (FormattedCharSequence line : charSeqLines) {
            guiGraphics.drawString(Minecraft.getInstance().font, line, backgroundPosX + 65, backgroundPosY + 55 + yOffset, 0, false);
            Objects.requireNonNull(this.font);
            yOffset += 9;
        }
    }

    public void renderMutagens(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        float scaleText = 0.67f;
        int maxLineWidth = 78;
        int backgroundPosX = (this.width - 256) / 2;
        int backgroundPosY = (this.height - 256) / 2;
        int textPosX = (this.width - maxLineWidth) / 2 - 30;
        int textPosY = (this.height - maxLineWidth) / 2 - 12;
        ArrayList<Holder<MobEffect>> effectCache = new ArrayList<Holder<MobEffect>>(3);
        int xOffset = 0;
        Objects.requireNonNull(this.font);
        int yOffsetAmount = Mth.ceil((float)(9.0f * scaleText));
        for (Holder<MobEffect> holder : this.toxData.getMutagens()) {
            if (holder.getKey() == null) continue;
            int dupeAmount = MutagenInfoScreen.getDuplicateMutagens(effectCache, holder);
            guiGraphics.blit(backgroundPosX + 61 + xOffset, backgroundPosY + 48, 0, 18, 18, this.effectTextureManager.get(holder));
            String level = switch (dupeAmount) {
                case 1 -> "||";
                case 2 -> "|||";
                default -> "|";
            };
            GraphicUtil.drawStringWithScale(guiGraphics, this.font, level, (float)(backgroundPosX + 95 + xOffset), (float)(backgroundPosY + 51), 1.5f, 16447203, true);
            guiGraphics.blitSprite(IMAGE_PANEL, 62, 149, 0, 0, backgroundPosX + 62 - 9 + xOffset, backgroundPosY + 45, 62, 149);
            MutableComponent textComponent = Component.translatable((String)("mutageninfo.toxony." + holder.getKey().location().getPath() + "." + dupeAmount)).withStyle(Style.EMPTY.withColor(13548929));
            List formatted = this.font.split((FormattedText)textComponent, maxLineWidth);
            int yOffset = 0;
            for (FormattedCharSequence line : formatted) {
                float f = textPosX + xOffset;
                float f2 = textPosY + yOffset;
                Objects.requireNonNull(this.font);
                GraphicUtil.drawStringWithScale(guiGraphics, this.font, line, f, f2 + 9.0f / 2.0f, scaleText, 0, false);
                yOffset += yOffsetAmount;
            }
            effectCache.add(holder);
            xOffset += 62;
        }
    }

    private static int getDuplicateMutagens(List<Holder<MobEffect>> list, Holder<MobEffect> effect) {
        int count = 0;
        for (Holder<MobEffect> effect1 : list) {
            if (effect1.value() != effect.value()) continue;
            ++count;
        }
        return count;
    }
}

