/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import xyz.yfrostyf.toxony.api.client.ClientToxData;

public class MutagenTransformOverlay
implements LayeredDraw.Layer {
    private static final ResourceLocation RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"textures/gui/overlays/mutagen_transform.png");
    private static final int[] TEXTURE_ARRAY = new int[]{0, 256, 512, 758, 1024, 1280, 1536, 1536, 1280, 1024, 758, 512, 256, 0};
    private static final int DEFAULT_PLAYTIME = 120;
    private static boolean active = false;
    private static int nextTickEnd = 0;

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (Minecraft.getInstance().options.hideGui || Minecraft.getInstance().player == null || Minecraft.getInstance().player.isSpectator() || ClientToxData.getToxData() == null) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (active && player.tickCount >= nextTickEnd || player.tickCount < 40) {
            active = false;
            nextTickEnd = player.tickCount;
        }
        if (active) {
            int screenWidth = guiGraphics.guiWidth();
            int screenHeight = guiGraphics.guiHeight();
            float progress = (float)(120 - (nextTickEnd - player.tickCount)) / 120.0f;
            int index = Mth.floor((float)(progress % (120.0f / (float)TEXTURE_ARRAY.length) * (float)TEXTURE_ARRAY.length));
            if (index >= TEXTURE_ARRAY.length || index < 0) {
                return;
            }
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            guiGraphics.setColor(0.2f, 0.9f, 0.2f, 0.8f);
            guiGraphics.blit(RESOURCE, 0, 0, screenWidth, screenHeight, 0.0f, (float)TEXTURE_ARRAY[index], 256, 256, 256, 1792);
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
        }
    }

    public static void startAnimation() {
        if (Minecraft.getInstance().options.hideGui || Minecraft.getInstance().player == null || Minecraft.getInstance().player.isSpectator() || active) {
            return;
        }
        nextTickEnd = Minecraft.getInstance().player.tickCount + 120;
        active = true;
    }
}

