/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import xyz.yfrostyf.toxony.api.mutagens.MutagenData;
import xyz.yfrostyf.toxony.registries.DataAttachmentRegistry;

public class NightPredatorOverlay
implements LayeredDraw.Layer {
    private static final ResourceLocation RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"textures/gui/overlays/night_predator_overlay.png");
    private static final int[] TEXTURE_ARRAY_ACTIVATE = new int[]{0, 256, 512, 758, 1024, 1280, 1536, 1792, 2048, 2304};
    private static final int[] TEXTURE_ARRAY_DEACTIVATE = new int[]{2304, 2048, 1792, 1536, 1280, 1024, 758, 512, 512, 512};
    private static final int DEFAULT_PLAYTIME = 20;
    private static boolean isActivating = true;
    private static boolean active = false;
    private static int nextTickEnd = 0;

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (Minecraft.getInstance().options.hideGui || Minecraft.getInstance().player == null || Minecraft.getInstance().player.isSpectator()) {
            return;
        }
        int screenWidth = guiGraphics.guiWidth();
        int screenHeight = guiGraphics.guiHeight();
        LocalPlayer player = Minecraft.getInstance().player;
        MutagenData mutagenData = (MutagenData)player.getData(DataAttachmentRegistry.MUTAGEN_DATA);
        if (active && player.tickCount >= nextTickEnd || player.tickCount < 40) {
            active = false;
            nextTickEnd = player.tickCount;
        }
        if (active) {
            float progress = (float)(20 - (nextTickEnd - player.tickCount)) / 20.0f;
            int index = Mth.floor((float)(progress % (20.0f / (float)TEXTURE_ARRAY_ACTIVATE.length) * (float)TEXTURE_ARRAY_ACTIVATE.length));
            if (index >= TEXTURE_ARRAY_ACTIVATE.length || index < 0) {
                return;
            }
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            guiGraphics.setColor(0.35f, 0.35f, 0.4f, 0.95f);
            if (isActivating) {
                guiGraphics.blit(RESOURCE, 0, 0, screenWidth, screenHeight, 0.0f, (float)TEXTURE_ARRAY_ACTIVATE[index], 256, 256, 256, 2560);
            } else {
                guiGraphics.blit(RESOURCE, 0, 0, screenWidth, screenHeight, 0.0f, (float)TEXTURE_ARRAY_DEACTIVATE[index], 256, 256, 256, 2560);
            }
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
        } else if (mutagenData.getBool("night_predator_active")) {
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            guiGraphics.setColor(0.35f, 0.35f, 0.4f, 0.95f);
            guiGraphics.blit(RESOURCE, 0, 0, screenWidth, screenHeight, 0.0f, (float)TEXTURE_ARRAY_DEACTIVATE[0], 256, 256, 256, 2560);
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
        }
    }

    public static void startAnimation() {
        if (Minecraft.getInstance().options.hideGui || Minecraft.getInstance().player == null || Minecraft.getInstance().player.isSpectator() || active) {
            return;
        }
        isActivating = true;
        nextTickEnd = Minecraft.getInstance().player.tickCount + 20;
        active = true;
    }

    public static void endAnimation() {
        if (Minecraft.getInstance().options.hideGui || Minecraft.getInstance().player == null || Minecraft.getInstance().player.isSpectator() || active) {
            return;
        }
        isActivating = false;
        nextTickEnd = Minecraft.getInstance().player.tickCount + 20;
        active = true;
    }
}

