/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.client.gui;

import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.fml.ModList;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import xyz.yfrostyf.toxony.api.client.ClientToxData;
import xyz.yfrostyf.toxony.registries.ItemRegistry;

public class ToxBarOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"textures/gui/tox_bars.png");
    static final int TEXTURE_WIDTH = 77;
    static final int TEXTURE_HEIGHT = 108;
    static final int BAR_WIDTH = 62;
    static final int BAR_HEIGHT = 9;
    static final int BAR_UOFFSET = 0;
    static final int BAR1_TOX_VOFFSET = 0;
    static final int BAR2_TOX_VOFFSET = 27;
    static final int BAR3_TOX_VOFFSET = 54;
    static final int BAR4_TOX_VOFFSET = 81;
    static final int BAR1_TOL_VOFFSET = 9;
    static final int BAR2_TOL_VOFFSET = 36;
    static final int BAR3_TOL_VOFFSET = 63;
    static final int BAR4_TOL_VOFFSET = 90;
    static final int BAR1_BACK_VOFFSET = 18;
    static final int BAR2_BACK_VOFFSET = 45;
    static final int BAR3_BACK_VOFFSET = 72;
    static final int BAR4_BACK_VOFFSET = 99;
    static final int SKULL_WIDTH = 9;
    static final int SKULL_HEIGHT = 21;
    static final int SKULL_UOFFSET = 67;
    static final int SKULL_WHITE_VOFFSET = 0;
    static final int SKULL_RED_VOFFSET = 21;

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        int BarTolVOffset;
        int BarBackVOffset;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (Minecraft.getInstance().options.hideGui) {
            return;
        }
        if (player.isSpectator()) {
            return;
        }
        if (!ToxBarOverlay.isToxGaugeOnPlayer((Player)player)) {
            return;
        }
        if (ClientToxData.getToxData() == null) {
            return;
        }
        float tox = ClientToxData.getToxData().getTox();
        float tolerance = ClientToxData.getToxData().getTolerance();
        float thresholdGoal = ClientToxData.getToxData().getThresholdTolGoal();
        boolean deathState = ClientToxData.getToxData().getDeathState();
        int BarToxVOffset = switch (ClientToxData.getToxData().getThreshold()) {
            case 0 -> {
                BarBackVOffset = 18;
                BarTolVOffset = 9;
                yield 0;
            }
            case 1 -> {
                BarBackVOffset = 45;
                BarTolVOffset = 36;
                yield 27;
            }
            case 2 -> {
                BarBackVOffset = 72;
                BarTolVOffset = 63;
                yield 54;
            }
            default -> {
                BarBackVOffset = 99;
                BarTolVOffset = 90;
                yield 81;
            }
        };
        int toxBarWidth = Mth.ceil((float)(62.0f * Math.min(tox / thresholdGoal, 1.0f)));
        int tolBarWidth = Mth.ceil((float)(62.0f * Math.min(tolerance / thresholdGoal, 1.0f)));
        int posX = guiGraphics.guiWidth() / 2 - 88;
        int posY = guiGraphics.guiHeight() - 72;
        guiGraphics.blit(RESOURCE, posX - 2, posY, 0.0f, (float)BarBackVOffset, 66, 9, 77, 108);
        guiGraphics.blit(RESOURCE, posX, posY, 0.0f, (float)BarTolVOffset, tolBarWidth, 9, 77, 108);
        guiGraphics.blit(RESOURCE, posX, posY, 0.0f, (float)BarToxVOffset, toxBarWidth, 9, 77, 108);
        guiGraphics.blit(RESOURCE, Math.clamp((long)(posX + toxBarWidth - 4), posX - 2, posX + 62 - 6), posY - 6, 67.0f, deathState ? 21.0f : 0.0f, 9, 21, 77, 108);
    }

    private static boolean isToxGaugeOnPlayer(Player player) {
        boolean isHolding = player.isHolding((Item)ItemRegistry.TOX_GAUGE.get());
        boolean isInCurios = false;
        if (ModList.get().isLoaded("curios") && CuriosApi.getCuriosInventory((LivingEntity)Minecraft.getInstance().player).isPresent()) {
            isInCurios = ((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)Minecraft.getInstance().player).get()).isEquipped((Item)ItemRegistry.TOX_GAUGE.get());
        }
        return isHolding || isInCurios;
    }
}

