/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.client.gui.block;

import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import xyz.yfrostyf.toxony.blocks.entities.AlchemicalForgeBlockEntity;
import xyz.yfrostyf.toxony.registries.BlockRegistry;
import xyz.yfrostyf.toxony.registries.ItemRegistry;
import xyz.yfrostyf.toxony.registries.MenuRegistry;

public class AlchemicalForgeMenu
extends AbstractContainerMenu {
    public final ItemStackHandler inventory;
    public final AlchemicalForgeBlockEntity blockEntity;
    public final ContainerLevelAccess access;
    public final ContainerData data;

    public AlchemicalForgeMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        this(id, inv, AlchemicalForgeMenu.getBlockEntity(inv, extraData), (ContainerData)new SimpleContainerData(2), ContainerLevelAccess.NULL);
    }

    public AlchemicalForgeMenu(int id, Inventory plyInventory, AlchemicalForgeBlockEntity blockEntity, ContainerData data, ContainerLevelAccess access) {
        super(MenuRegistry.ALCHEMICAL_FORGE_MENU.get(), id);
        int i;
        this.inventory = blockEntity.getItemContainer();
        this.blockEntity = blockEntity;
        this.data = data;
        this.access = access;
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.inventory, 0, 80, 43));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.inventory, 1, 54, 43));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.inventory, 2, 106, 43));
        for (i = 0; i < 3; ++i) {
            this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.inventory, 3 + i, 60 + 20 * i, 7){

                public boolean mayPlace(ItemStack stack) {
                    return stack.is(ItemRegistry.AFFINITY_SOLUTION);
                }
            });
        }
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.inventory, 6, 19, 16){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(ItemRegistry.TOXIN);
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)plyInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)plyInventory, k, 8 + k * 18, 142));
        }
    }

    private static AlchemicalForgeBlockEntity getBlockEntity(Inventory plyInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(plyInventory, "plyInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity blockAtPos = plyInventory.player.level().getBlockEntity(data.readBlockPos());
        if (blockAtPos instanceof AlchemicalForgeBlockEntity) {
            return (AlchemicalForgeBlockEntity)blockAtPos;
        }
        throw new IllegalStateException("The block entity is not correct at AlchemicalForgeBlockEntity#getBLockEntity " + String.valueOf(blockAtPos));
    }

    public ItemStack quickMoveStack(Player player, int selectedSlotIndex) {
        Slot selectedSlot = (Slot)this.slots.get(selectedSlotIndex);
        if (selectedSlot == null || !selectedSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack rawStack = selectedSlot.getItem();
        ItemStack selectedStack = rawStack.copy();
        if (selectedSlotIndex >= 0 && selectedSlotIndex < 7 ? !this.moveItemStackTo(rawStack, 7, 43, true) : (rawStack.is(ItemRegistry.TOXIN) ? !this.moveItemStackTo(rawStack, 6, 7, true) && (selectedSlotIndex < 34 ? !this.moveItemStackTo(rawStack, 34, 43, false) : !this.moveItemStackTo(rawStack, 7, 34, false)) : (rawStack.is(ItemRegistry.AFFINITY_SOLUTION) ? !this.moveItemStackTo(rawStack, 3, 6, true) && (selectedSlotIndex < 34 ? !this.moveItemStackTo(rawStack, 34, 43, false) : !this.moveItemStackTo(rawStack, 7, 34, false)) : !this.moveItemStackTo(rawStack, 0, 3, false) && !this.moveItemStackTo(rawStack, 3, 6, true) && (selectedSlotIndex < 35 ? !this.moveItemStackTo(rawStack, 35, 44, false) : !this.moveItemStackTo(rawStack, 7, 35, false))))) {
            return ItemStack.EMPTY;
        }
        if (rawStack.isEmpty()) {
            selectedSlot.set(ItemStack.EMPTY);
        } else {
            selectedSlot.setChanged();
        }
        if (rawStack.getCount() == selectedStack.getCount()) {
            return ItemStack.EMPTY;
        }
        selectedSlot.onTake(player, rawStack);
        return selectedStack;
    }

    public boolean stillValid(Player player) {
        return AlchemicalForgeMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)BlockRegistry.ALCHEMICAL_FORGE.get()));
    }
}

