/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.client.gui.block;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import xyz.yfrostyf.toxony.client.gui.block.AlchemicalForgeMenu;
import xyz.yfrostyf.toxony.network.ClientStartAlchemicalForgePacket;

public class AlchemicalForgeScreen
extends AbstractContainerScreen<AlchemicalForgeMenu> {
    public static final ResourceLocation ALCHEMICAL_FORGE_MENU = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"textures/gui/container/alchemical_forge_menu.png");
    static final ResourceLocation ALCHEMICAL_FORGE_FUEL = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"container/alchemical_forge_fuel");
    static final ResourceLocation ALCHEMICAL_FORGE_BUTTON_ACTIVE = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"container/alchemical_forge_button_active");
    static final ResourceLocation ALCHEMICAL_FORGE_BUTTON_INACTIVE = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"container/alchemical_forge_button_inactive");
    static final ResourceLocation ALCHEMICAL_FORGE_BUTTON_HOVER = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"container/alchemical_forge_button_hover");
    protected AlchemicalForgeConfirmButton cbutton;
    private final AlchemicalForgeMenu menu;
    protected Player player;

    public AlchemicalForgeScreen(AlchemicalForgeMenu menu, Inventory plyInventory, Component title) {
        super((AbstractContainerMenu)menu, plyInventory, title);
        this.menu = menu;
        this.player = plyInventory.player;
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    protected void init() {
        super.init();
        this.cbutton = new AlchemicalForgeConfirmButton(this.leftPos + 76, this.topPos + 65, this);
        this.addRenderableWidget((GuiEventListener)this.cbutton);
        this.cbutton.active = false;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int FUEL_WIDTH = 7;
        int FUEL_HEIGHT = 23;
        int FUEL_POSX = this.imageWidth - 32;
        int FUEL_POSY = 69;
        int half_screen_x = (this.width - this.imageWidth) / 2;
        int half_screen_y = (this.height - this.imageHeight) / 2;
        int fuelHeight = Mth.ceil((float)(23.0f * this.menu.blockEntity.getFuelPercentage()));
        guiGraphics.blit(ALCHEMICAL_FORGE_MENU, half_screen_x, half_screen_y, 0, 0, this.imageWidth, this.imageHeight);
        if (this.menu.blockEntity.hasFuel()) {
            guiGraphics.blitSprite(ALCHEMICAL_FORGE_FUEL, 7, 23, 0, 23 - fuelHeight, this.leftPos + FUEL_POSX, this.topPos + 69 - fuelHeight, 7, fuelHeight);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void containerTick() {
        this.cbutton.active = this.menu.blockEntity.canForge();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static class AlchemicalForgeConfirmButton
    extends AbstractButton {
        static final int BUTTON_WIDTH = 23;
        static final int BUTTON_HEIGHT = 13;
        private final AlchemicalForgeScreen screen;

        protected AlchemicalForgeConfirmButton(int x, int y, AlchemicalForgeScreen screen) {
            super(x, y, 23, 13, CommonComponents.EMPTY);
            this.screen = screen;
            screen.cbutton = this;
        }

        public void onPress() {
            if (!this.active) {
                return;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new ClientStartAlchemicalForgePacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.screen.player.closeContainer();
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (!this.active) {
                guiGraphics.blitSprite(ALCHEMICAL_FORGE_BUTTON_INACTIVE, 23, 13, 0, 0, this.getX(), this.getY(), 23, 13);
            } else if (this.isHoveredOrFocused()) {
                guiGraphics.blitSprite(ALCHEMICAL_FORGE_BUTTON_HOVER, 23, 13, 0, 0, this.getX(), this.getY(), 23, 13);
            } else {
                guiGraphics.blitSprite(ALCHEMICAL_FORGE_BUTTON_ACTIVE, 23, 13, 0, 0, this.getX(), this.getY(), 23, 13);
            }
        }

        public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            this.defaultButtonNarrationText(narrationElementOutput);
        }
    }
}

