/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.client.gui.block;

import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import xyz.yfrostyf.toxony.blocks.entities.AlembicBlockEntity;
import xyz.yfrostyf.toxony.recipes.AlembicRecipe;
import xyz.yfrostyf.toxony.registries.BlockRegistry;
import xyz.yfrostyf.toxony.registries.MenuRegistry;
import xyz.yfrostyf.toxony.registries.RecipeRegistry;

public class AlembicMenu
extends AbstractContainerMenu {
    public final ItemStackHandler inventory;
    public final AlembicBlockEntity blockEntity;
    public final ContainerData data;
    public final ContainerLevelAccess access;
    private static final RecipeType<AlembicRecipe> recipeType = RecipeRegistry.ALEMBIC_RECIPE.get();

    public AlembicMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        this(id, inv, AlembicMenu.getBlockEntity(inv, extraData), (ContainerData)new SimpleContainerData(3), ContainerLevelAccess.NULL);
    }

    public AlembicMenu(int id, Inventory plyInventory, AlembicBlockEntity blockEntity, ContainerData data, ContainerLevelAccess access) {
        super(MenuRegistry.ALEMBIC_MENU.get(), id);
        this.inventory = blockEntity.getItemContainer();
        this.blockEntity = blockEntity;
        AlembicMenu.checkContainerDataCount((ContainerData)data, (int)3);
        this.data = data;
        this.access = access;
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.inventory, 0, 116, 46){

            public void setChanged() {
                AlembicMenu.this.slotsChanged(this.container);
                this.container.setChanged();
            }
        });
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.inventory, 1, 80, 51){

            public void setChanged() {
                AlembicMenu.this.slotsChanged(this.container);
                this.container.setChanged();
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.inventory, 2, 30, 24){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(Items.BLAZE_POWDER);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)plyInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)plyInventory, k, 8 + k * 18, 142));
        }
        this.addDataSlots(data);
    }

    private static AlembicBlockEntity getBlockEntity(Inventory plyInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(plyInventory, "plyInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity blockAtPos = plyInventory.player.level().getBlockEntity(data.readBlockPos());
        if (blockAtPos instanceof AlembicBlockEntity) {
            return (AlembicBlockEntity)blockAtPos;
        }
        throw new IllegalStateException("The block entity is not correct at AlembicBlockMenu#getBLockEntity " + String.valueOf(blockAtPos));
    }

    public void slotsChanged(Container container) {
        if (this.blockEntity.getLevel() == null) {
            return;
        }
        this.blockEntity.resetAlembic();
        this.blockEntity.getLevel().sendBlockUpdated(this.blockEntity.getBlockPos(), this.blockEntity.getBlockState(), this.blockEntity.getBlockState(), 2);
        super.slotsChanged(container);
    }

    public ItemStack quickMoveStack(Player player, int selectedSlotIndex) {
        ItemStack selectedStack = ItemStack.EMPTY;
        Slot selectedSlot = (Slot)this.slots.get(selectedSlotIndex);
        if (selectedSlot == null || !selectedSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack rawStack = selectedSlot.getItem();
        selectedStack = rawStack.copy();
        if (selectedSlotIndex >= 0 && selectedSlotIndex < 3 ? !this.moveItemStackTo(rawStack, 3, 39, true) : selectedSlotIndex >= 3 && selectedSlotIndex < 39 && (selectedSlot.getItem().is(Items.BLAZE_POWDER) ? !this.moveItemStackTo(rawStack, 2, 3, false) && (selectedSlotIndex < 30 ? !this.moveItemStackTo(rawStack, 30, 39, false) : !this.moveItemStackTo(rawStack, 3, 30, false)) : !this.moveItemStackTo(rawStack, 1, 2, false) && !this.moveItemStackTo(rawStack, 0, 1, false) && (selectedSlotIndex < 30 ? !this.moveItemStackTo(rawStack, 30, 39, false) : !this.moveItemStackTo(rawStack, 3, 30, false)))) {
            return ItemStack.EMPTY;
        }
        if (rawStack.isEmpty()) {
            selectedSlot.set(ItemStack.EMPTY);
        } else {
            selectedSlot.setChanged();
        }
        if (rawStack.getCount() == selectedStack.getCount()) {
            return ItemStack.EMPTY;
        }
        selectedSlot.onTake(player, rawStack);
        return selectedStack;
    }

    public boolean stillValid(Player player) {
        return AlembicMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)BlockRegistry.ALEMBIC.get()));
    }

    public boolean isBoiling() {
        return this.data.get(1) > 0;
    }

    public boolean hasFuel() {
        return this.data.get(0) > 0;
    }

    public float getBoilProgress() {
        int i = this.data.get(1);
        int j = this.data.get(2);
        return j != 0 && i != 0 ? Mth.clamp((float)((float)i / (float)j), (float)0.0f, (float)1.0f) : 0.0f;
    }

    public float getBoilTick() {
        return this.data.get(1);
    }

    public float getFuelProgress() {
        return Mth.clamp((float)((float)this.data.get(0) / 10000.0f), (float)0.0f, (float)1.0f);
    }
}

