/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.client.gui.block;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import xyz.yfrostyf.toxony.client.gui.block.AlembicMenu;

public class AlembicScreen
extends AbstractContainerScreen<AlembicMenu> {
    private static final ResourceLocation ALEMBIC_MENU = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"textures/gui/container/alembic_menu.png");
    private static final ResourceLocation ALEMBIC_FUEL = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"container/alembic_fuel");
    private static final ResourceLocation PROGRESS_BAR = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"container/progress_bar");
    private static final ResourceLocation ALEMBIC_BUBBLES = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"container/bubbles");
    private static final int[] BUBBLE_LENGTHS = new int[]{27, 24, 20, 16, 11, 6, 0};
    private final AlembicMenu menu;

    public AlembicScreen(AlembicMenu menu, Inventory plyInventory, Component title) {
        super((AbstractContainerMenu)menu, plyInventory, title);
        this.menu = menu;
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int FUEL_WIDTH = 18;
        int FUEL_HEIGHT = 4;
        int FUEL_POSX = 51;
        int FUEL_POSY = 63;
        int BAR_WIDTH = 3;
        int BAR_HEIGHT = 25;
        int BAR_POSX = 143;
        int BAR_POSY = 66;
        int BUBBLE_WIDTH = 10;
        int BUBBLE_HEIGHT = 27;
        int BUBBLE_POSX = 55;
        int BUBBLE_POSY = 60;
        int half_screen_x = (this.width - this.imageWidth) / 2;
        int half_screen_y = (this.height - this.imageHeight) / 2;
        int fuelWidth = (int)Mth.clamp((float)(18.0f * this.menu.getFuelProgress()), (float)0.0f, (float)18.0f);
        int barHeight = Mth.ceil((float)(25.0f * this.menu.getBoilProgress()));
        int bubbleHeight = BUBBLE_LENGTHS[(int)this.menu.getBoilTick() / 2 % 7];
        guiGraphics.blit(ALEMBIC_MENU, half_screen_x, half_screen_y, 0, 0, this.imageWidth, this.imageHeight);
        if (this.menu.hasFuel()) {
            guiGraphics.blitSprite(ALEMBIC_FUEL, 18, 4, 0, 0, this.leftPos + 51, this.topPos + 63, fuelWidth, 4);
        }
        if (this.menu.isBoiling()) {
            guiGraphics.blitSprite(PROGRESS_BAR, 3, 25, 0, 25 - barHeight, this.leftPos + 143, this.topPos + 66 - barHeight, 3, barHeight);
            if (bubbleHeight > 0) {
                guiGraphics.blitSprite(ALEMBIC_BUBBLES, 10, 27, 0, 27 - bubbleHeight, this.leftPos + 55, this.topPos + 60 - bubbleHeight, 10, bubbleHeight);
            }
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }
}

