/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.client.gui.block;

import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import xyz.yfrostyf.toxony.blocks.entities.CopperCrucibleBlockEntity;
import xyz.yfrostyf.toxony.recipes.CrucibleRecipe;
import xyz.yfrostyf.toxony.registries.BlockRegistry;
import xyz.yfrostyf.toxony.registries.MenuRegistry;
import xyz.yfrostyf.toxony.registries.RecipeRegistry;

public class CopperCrucibleMenu
extends AbstractContainerMenu {
    public final ItemStackHandler inventory;
    public final CopperCrucibleBlockEntity blockEntity;
    public final ContainerData data;
    public final ContainerLevelAccess access;
    private static final RecipeType<CrucibleRecipe> recipeType = RecipeRegistry.CRUCIBLE_RECIPE.get();

    public CopperCrucibleMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        this(id, inv, CopperCrucibleMenu.getBlockEntity(inv, extraData), (ContainerData)new SimpleContainerData(4), ContainerLevelAccess.NULL);
    }

    public CopperCrucibleMenu(int id, Inventory plyInventory, CopperCrucibleBlockEntity blockEntity, ContainerData data, ContainerLevelAccess access) {
        super(MenuRegistry.COPPER_CRUCIBLE_MENU.get(), id);
        this.inventory = blockEntity.getItemContainer();
        this.blockEntity = blockEntity;
        CopperCrucibleMenu.checkContainerDataCount((ContainerData)data, (int)4);
        this.data = data;
        this.access = access;
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.inventory, 0, 80, 21){

            public void setChanged() {
                CopperCrucibleMenu.this.slotsChanged(this.container);
                this.container.setChanged();
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.inventory, 1, 80, 55){

            public boolean mayPlace(ItemStack stack) {
                if (stack.getBurnTime(recipeType) <= 0) {
                    return false;
                }
                return super.mayPlace(stack);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)plyInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)plyInventory, k, 8 + k * 18, 142));
        }
        this.addDataSlots(data);
    }

    private static CopperCrucibleBlockEntity getBlockEntity(Inventory plyInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(plyInventory, "plyInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity blockAtPos = plyInventory.player.level().getBlockEntity(data.readBlockPos());
        if (blockAtPos instanceof CopperCrucibleBlockEntity) {
            return (CopperCrucibleBlockEntity)blockAtPos;
        }
        throw new IllegalStateException("The block entity is not correct at CopperCrucibleMenu#getBLockEntity " + String.valueOf(blockAtPos));
    }

    public void slotsChanged(Container container) {
        if (this.blockEntity.getLevel() == null) {
            return;
        }
        this.blockEntity.resetCrucible();
        this.blockEntity.getLevel().sendBlockUpdated(this.blockEntity.getBlockPos(), this.blockEntity.getBlockState(), this.blockEntity.getBlockState(), 2);
        super.slotsChanged(container);
    }

    public ItemStack quickMoveStack(Player player, int selectedSlotIndex) {
        ItemStack selectedStack = ItemStack.EMPTY;
        Slot selectedSlot = (Slot)this.slots.get(selectedSlotIndex);
        if (selectedSlot == null || !selectedSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack rawStack = selectedSlot.getItem();
        selectedStack = rawStack.copy();
        if (selectedSlotIndex >= 0 && selectedSlotIndex < 2 ? !this.moveItemStackTo(rawStack, 2, 38, true) : selectedSlotIndex >= 2 && selectedSlotIndex < 38 && (selectedSlot.getItem().getBurnTime(recipeType) > 0 ? !this.moveItemStackTo(rawStack, 1, 2, false) && !this.moveItemStackTo(rawStack, 0, 1, false) && (selectedSlotIndex < 29 ? !this.moveItemStackTo(rawStack, 29, 38, false) : !this.moveItemStackTo(rawStack, 2, 29, false)) : !this.moveItemStackTo(rawStack, 0, 1, false) && (selectedSlotIndex < 29 ? !this.moveItemStackTo(rawStack, 29, 38, false) : !this.moveItemStackTo(rawStack, 2, 29, false)))) {
            return ItemStack.EMPTY;
        }
        if (rawStack.isEmpty()) {
            selectedSlot.set(ItemStack.EMPTY);
        } else {
            selectedSlot.setChanged();
        }
        if (rawStack.getCount() == selectedStack.getCount()) {
            return ItemStack.EMPTY;
        }
        selectedSlot.onTake(player, rawStack);
        return selectedStack;
    }

    public boolean stillValid(Player player) {
        return CopperCrucibleMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)BlockRegistry.COPPER_CRUCIBLE.get()));
    }

    protected boolean isFuel(ItemStack stack) {
        return stack.getBurnTime(recipeType) > 0;
    }

    public float getCookProgress() {
        int i = this.data.get(2);
        int j = this.data.get(3);
        return j != 0 && i != 0 ? Mth.clamp((float)((float)i / (float)j), (float)0.0f, (float)1.0f) : 0.0f;
    }

    public float getLitProgress() {
        int i = this.data.get(1);
        if (i == 0) {
            i = 200;
        }
        return Mth.clamp((float)((float)this.data.get(0) / (float)i), (float)0.0f, (float)1.0f);
    }

    public boolean isCooking() {
        return this.data.get(2) > 0;
    }

    public boolean isLit() {
        return this.data.get(0) > 0;
    }
}

