/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.client.gui.block;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import xyz.yfrostyf.toxony.client.gui.block.CopperCrucibleMenu;

public class CopperCrucibleScreen
extends AbstractContainerScreen<CopperCrucibleMenu> {
    private static final ResourceLocation COPPER_CRUCIBLE_MENU = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"textures/gui/container/copper_crucible_menu.png");
    static final ResourceLocation COPPER_CRUCIBLE_FLAMES = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"container/crucible_flames");
    static final ResourceLocation PROGRESS_BAR = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"container/progress_bar");
    private final CopperCrucibleMenu menu;

    public CopperCrucibleScreen(CopperCrucibleMenu menu, Inventory plyInventory, Component title) {
        super((AbstractContainerMenu)menu, plyInventory, title);
        this.menu = menu;
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int FIRE_WIDTH = 13;
        int FIRE_HEIGHT = 11;
        int FIRE_POSX = 81;
        int FIRE_POSY = 53;
        int BAR_WIDTH = 3;
        int BAR_HEIGHT = 25;
        int BAR_POSX = 115;
        int BAR_POSY = 42;
        int half_screen_x = (this.width - this.imageWidth) / 2;
        int half_screen_y = (this.height - this.imageHeight) / 2;
        int fireHeight = Mth.ceil((float)(11.0f * this.menu.getLitProgress()));
        int barHeight = Mth.ceil((float)(25.0f * this.menu.getCookProgress()));
        guiGraphics.blit(COPPER_CRUCIBLE_MENU, half_screen_x, half_screen_y, 0, 0, this.imageWidth, this.imageHeight);
        if (this.menu.isLit()) {
            guiGraphics.blitSprite(COPPER_CRUCIBLE_FLAMES, 13, 11, 0, 11 - fireHeight, this.leftPos + 81, this.topPos + 53 - fireHeight, 13, fireHeight);
        }
        if (this.menu.isCooking()) {
            guiGraphics.blitSprite(PROGRESS_BAR, 3, 25, 0, 25 - barHeight, this.leftPos + 115, this.topPos + 42 - barHeight, 3, barHeight);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }
}

