/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.client.gui.block;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import xyz.yfrostyf.toxony.blocks.entities.MortarPestleBlockEntity;
import xyz.yfrostyf.toxony.client.gui.block.MortarPestleMenu;
import xyz.yfrostyf.toxony.network.ClientStartPestlingPacket;

public class MortarPestleScreen
extends AbstractContainerScreen<MortarPestleMenu> {
    private static final ResourceLocation MORTAR_PESTLE_MENU = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"textures/gui/container/mortar_pestle_menu.png");
    static final ResourceLocation MORTAR_PESTLE_BUTTON_ACTIVE = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"container/mortar_pestle_button_active");
    static final ResourceLocation MORTAR_PESTLE_BUTTON_INACTIVE = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"container/mortar_pestle_button_inactive");
    static final ResourceLocation MORTAR_PESTLE_BUTTON_HOVER = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"container/mortar_pestle_button_hover");
    private final MortarPestleMenu menu;
    protected MortarPestleConfirmButton cbutton;
    protected MortarPestleBlockEntity blockEntity;
    protected Player player;

    public MortarPestleScreen(MortarPestleMenu menu, Inventory plyInventory, Component title) {
        super((AbstractContainerMenu)menu, plyInventory, title);
        this.menu = menu;
        this.player = plyInventory.player;
        this.blockEntity = menu.blockEntity;
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    protected void init() {
        super.init();
        this.cbutton = new MortarPestleConfirmButton(this.leftPos + 108, this.topPos + 32, this);
        this.addRenderableWidget((GuiEventListener)this.cbutton);
        this.cbutton.active = false;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int half_screen_x = (this.width - this.imageWidth) / 2;
        int half_screen_y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(MORTAR_PESTLE_MENU, half_screen_x, half_screen_y, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void containerTick() {
        this.cbutton.active = !this.blockEntity.getResultItem().isEmpty();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static class MortarPestleConfirmButton
    extends AbstractButton {
        static final int BUTTON_TEXTURE_WIDTH = 25;
        static final int BUTTON_TEXTURE_HEIGHT = 17;
        private final MortarPestleScreen screen;

        protected MortarPestleConfirmButton(int x, int y, MortarPestleScreen screen) {
            super(x, y, 25, 17, CommonComponents.EMPTY);
            this.screen = screen;
            screen.cbutton = this;
        }

        public void onPress() {
            if (!this.active) {
                return;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new ClientStartPestlingPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.screen.player.closeContainer();
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (!this.active) {
                guiGraphics.blitSprite(MORTAR_PESTLE_BUTTON_INACTIVE, 25, 17, 0, 0, this.getX(), this.getY(), 25, 17);
            } else if (this.isHoveredOrFocused()) {
                guiGraphics.blitSprite(MORTAR_PESTLE_BUTTON_HOVER, 25, 17, 0, 0, this.getX(), this.getY(), 25, 17);
            } else {
                guiGraphics.blitSprite(MORTAR_PESTLE_BUTTON_ACTIVE, 25, 17, 0, 0, this.getX(), this.getY(), 25, 17);
            }
        }

        public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            this.defaultButtonNarrationText(narrationElementOutput);
        }
    }
}

