/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.client.gui.block;

import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import xyz.yfrostyf.toxony.blocks.entities.RedstoneMortarBlockEntity;
import xyz.yfrostyf.toxony.registries.BlockRegistry;
import xyz.yfrostyf.toxony.registries.MenuRegistry;

public class RedstoneMortarMenu
extends AbstractContainerMenu {
    public final ItemStackHandler inventory;
    public final RedstoneMortarBlockEntity blockEntity;
    public final ContainerLevelAccess access;
    public final ContainerData data;

    public RedstoneMortarMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        this(id, inv, RedstoneMortarMenu.getBlockEntity(inv, extraData), (ContainerData)new SimpleContainerData(3), ContainerLevelAccess.NULL);
    }

    public RedstoneMortarMenu(int id, Inventory plyInventory, RedstoneMortarBlockEntity blockEntity, ContainerData data, ContainerLevelAccess access) {
        super(MenuRegistry.REDSTONE_MORTAR_MENU.get(), id);
        int j;
        int i;
        this.inventory = blockEntity.getItemContainer();
        this.blockEntity = blockEntity;
        RedstoneMortarMenu.checkContainerDataCount((ContainerData)data, (int)3);
        this.data = data;
        this.access = access;
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 2; ++j) {
                this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.inventory, j + i * 2, 52 + j * 18, 25 + i * 18){

                    public void setChanged() {
                        RedstoneMortarMenu.this.slotsChanged(this.container);
                        super.setChanged();
                    }
                });
            }
        }
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.inventory, 4, 103, 52){

            public void setChanged() {
                RedstoneMortarMenu.this.slotsChanged(this.container);
                super.setChanged();
            }
        });
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.inventory, 5, 130, 33));
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)plyInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)plyInventory, k, 8 + k * 18, 142));
        }
        this.addDataSlots(data);
    }

    private static RedstoneMortarBlockEntity getBlockEntity(Inventory plyInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(plyInventory, "plyInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity blockAtPos = plyInventory.player.level().getBlockEntity(data.readBlockPos());
        if (blockAtPos instanceof RedstoneMortarBlockEntity) {
            return (RedstoneMortarBlockEntity)blockAtPos;
        }
        throw new IllegalStateException("The block entity is not correct at RedstoneMortarMenu#getBLockEntity " + String.valueOf(blockAtPos));
    }

    public ItemStack quickMoveStack(Player player, int selectedSlotIndex) {
        ItemStack selectedStack = ItemStack.EMPTY;
        Slot selectedSlot = (Slot)this.slots.get(selectedSlotIndex);
        if (selectedSlot == null || !selectedSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack rawStack = selectedSlot.getItem();
        selectedStack = rawStack.copy();
        if (selectedSlotIndex >= 0 && selectedSlotIndex < 6 ? !this.moveItemStackTo(rawStack, 6, 42, true) : selectedSlotIndex >= 6 && selectedSlotIndex < 42 && !this.moveItemStackTo(rawStack, 0, 4, false) && (selectedSlotIndex < 33 ? !this.moveItemStackTo(rawStack, 33, 42, false) : !this.moveItemStackTo(rawStack, 6, 33, false))) {
            return ItemStack.EMPTY;
        }
        if (rawStack.isEmpty()) {
            selectedSlot.set(ItemStack.EMPTY);
        } else {
            selectedSlot.setChanged();
        }
        if (rawStack.getCount() == selectedStack.getCount()) {
            return ItemStack.EMPTY;
        }
        selectedSlot.onTake(player, rawStack);
        return selectedStack;
    }

    public boolean isPestling() {
        return this.data.get(0) == 1;
    }

    public float getPestleProgress() {
        return (float)this.data.get(1) / 5.0f;
    }

    public void slotsChanged(Container container) {
        if (this.blockEntity.getLevel() == null) {
            return;
        }
        if (this.blockEntity.isPestling) {
            this.blockEntity.resetPestling();
        }
        super.slotsChanged(container);
    }

    public boolean stillValid(Player player) {
        return RedstoneMortarMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)BlockRegistry.REDSTONE_MORTAR.get()));
    }
}

