/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.client.gui.block;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import xyz.yfrostyf.toxony.blocks.entities.RedstoneMortarBlockEntity;
import xyz.yfrostyf.toxony.client.gui.block.RedstoneMortarMenu;

public class RedstoneMortarScreen
extends AbstractContainerScreen<RedstoneMortarMenu> {
    private static final ResourceLocation REDSTONE_MORTAR_MENU = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"textures/gui/container/redstone_mortar_menu.png");
    private static final ResourceLocation PROGRESS_ARROW = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"container/progress_arrow");
    int PROGRESS_ARROW_WIDTH = 10;
    int PROGRESS_ARROW_HEIGHT = 7;
    private final RedstoneMortarMenu menu;
    protected RedstoneMortarBlockEntity blockEntity;
    protected Player player;

    public RedstoneMortarScreen(RedstoneMortarMenu menu, Inventory plyInventory, Component title) {
        super((AbstractContainerMenu)menu, plyInventory, title);
        this.menu = menu;
        this.player = plyInventory.player;
        this.blockEntity = menu.blockEntity;
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    protected void init() {
        super.init();
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int half_screen_x = (this.width - this.imageWidth) / 2;
        int half_screen_y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(REDSTONE_MORTAR_MENU, half_screen_x, half_screen_y, 0, 0, this.imageWidth, this.imageHeight);
        if (this.menu.isPestling()) {
            float progress = this.menu.getPestleProgress();
            guiGraphics.blitSprite(PROGRESS_ARROW, this.PROGRESS_ARROW_WIDTH, this.PROGRESS_ARROW_HEIGHT, 0, 0, this.leftPos + 107, this.topPos + 38, Mth.floor((float)((float)this.PROGRESS_ARROW_WIDTH * progress)), this.PROGRESS_ARROW_HEIGHT);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }
}

