/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.client.gui.journal;

import com.mojang.datafixers.util.Pair;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import xyz.yfrostyf.toxony.api.affinity.Affinity;
import xyz.yfrostyf.toxony.client.gui.journal.JournalPages;
import xyz.yfrostyf.toxony.client.gui.journal.PageScreen;

public class GraftingPageScreen
extends PageScreen {
    protected static final ResourceLocation IMAGE = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"textures/gui/journal/journal_background.png");
    private static final ResourceLocation GRAFTING_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"journal/grafting_menu");
    private static final ResourceLocation GRAFTING_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"textures/gui/journal/journal_grafting_background.png");
    private static final ResourceLocation AFFINITY_IMAGE = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"textures/gui/affinity_icons.png");
    protected static final int IMAGE_WIDTH = 203;
    protected static final int IMAGE_HEIGHT = 237;
    private static final int GRAFTING_IMAGE_WIDTH = 78;
    private static final int GRAFTING_IMAGE_HEIGHT = 18;
    private static final int AFFINITY_IMAGE_WIDTH = 52;
    private static final int AFFINITY_IMAGE_HEIGHT = 39;
    private static final int ICON_WIDTH = 13;
    private static final int ICON_HEIGHT = 13;
    private final Map<Pair<ItemStack, ItemStack>, Affinity> inputs;

    public GraftingPageScreen(String translateID, Map<Pair<ItemStack, ItemStack>, Affinity> inputs, int indexID, JournalPages journalPages) {
        super(translateID, indexID, journalPages);
        this.inputs = inputs;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int backgroundPosX = (this.width - 203) / 2;
        int backgroundPosY = (this.height - 237) / 2;
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.blit(IMAGE, backgroundPosX, backgroundPosY, 0, 0, 203, 237);
        guiGraphics.blit(GRAFTING_BACKGROUND, backgroundPosX, backgroundPosY, 0, 0, 203, 237);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int halfScreenPosX = this.width / 2;
        int halfScreenPosY = this.height / 2;
        int posX = halfScreenPosX - 35;
        int posY = halfScreenPosY - 45;
        int posXOffsetAffinity = 31;
        int posXOffsetEvolved = 60;
        int i = 0;
        for (Map.Entry<Pair<ItemStack, ItemStack>, Affinity> entry : this.inputs.entrySet()) {
            int index = entry.getValue().getIndex();
            ItemStack base = (ItemStack)entry.getKey().getFirst();
            ItemStack evolved = (ItemStack)entry.getKey().getSecond();
            guiGraphics.blitSprite(GRAFTING_SPRITE, 78, 18, 0, 0, posX - 1, posY - 1 + i, 78, 18);
            guiGraphics.blit(AFFINITY_IMAGE, posX + posXOffsetAffinity, posY + i, (float)(index * 13), (float)((int)((double)(index / 4) * 13.0)), 13, 13, 52, 39);
            guiGraphics.renderItem(base, posX, posY + i);
            guiGraphics.renderItemDecorations(this.minecraft.font, base, posX, posY + i, null);
            guiGraphics.renderItem(evolved, posX + posXOffsetEvolved, posY + i);
            guiGraphics.renderItemDecorations(this.minecraft.font, evolved, posX + posXOffsetEvolved, posY + i, null);
            if (mouseX > posX && mouseX < posX + 16 && mouseY > posY + i && mouseY < posY + i + 16) {
                guiGraphics.renderComponentTooltip(this.minecraft.font, Screen.getTooltipFromItem((Minecraft)this.minecraft, (ItemStack)base), mouseX, mouseY);
            }
            if (mouseX > posX + posXOffsetEvolved && mouseX < posX + posXOffsetEvolved + 16 && mouseY > posY + i && mouseY < posY + i + 16) {
                guiGraphics.renderComponentTooltip(this.minecraft.font, Screen.getTooltipFromItem((Minecraft)this.minecraft, (ItemStack)evolved), mouseX, mouseY);
            }
            i += 20;
        }
    }
}

