/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.client.gui.journal;

import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import xyz.yfrostyf.toxony.client.gui.journal.JournalPages;
import xyz.yfrostyf.toxony.client.gui.journal.TextPageScreen;

public class IndexPageScreen
extends TextPageScreen {
    protected final Map<String, String> indexedPages;
    protected final Font font;

    protected IndexPageScreen(String translateID, Map<String, String> indexedPages, int indexID, JournalPages journalPages) {
        super(translateID, indexID, journalPages);
        this.indexedPages = indexedPages;
        this.font = Minecraft.getInstance().font;
    }

    @Override
    protected void init() {
        super.init();
        int i = 0;
        for (Map.Entry<String, String> entry : this.indexedPages.entrySet()) {
            MutableComponent component = Component.translatable((String)entry.getKey());
            Button.OnPress onPress = b -> {
                this.journalPages.setPage((String)entry.getValue());
                this.journalPages.updatePage();
            };
            int n = this.width / 2 - 56;
            int n2 = this.height / 2 - 45;
            Objects.requireNonNull(this.font);
            this.addRenderableWidget((GuiEventListener)new IndexTextButton(n, n2 + i * (9 + 1), (Component)component, onPress, this.font));
            ++i;
        }
    }

    public static class IndexTextButton
    extends Button {
        private final Font font;
        private final Component message;
        private final Component underlinedMessage;

        public IndexTextButton(int x, int y, Component message, Button.OnPress onPress, Font font) {
            int n = font.width((FormattedText)message);
            Objects.requireNonNull(font);
            super(x, y, n, 9, message, onPress, DEFAULT_NARRATION);
            this.font = font;
            this.message = ComponentUtils.mergeStyles((MutableComponent)message.copy(), (Style)Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(13548929));
            this.underlinedMessage = ComponentUtils.mergeStyles((MutableComponent)message.copy(), (Style)Style.EMPTY.withBold(Boolean.valueOf(true)).withUnderlined(Boolean.valueOf(true)).withColor(13548929));
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            Component component = this.isHoveredOrFocused() ? this.underlinedMessage : this.message;
            guiGraphics.drawString(this.font, component, this.getX(), this.getY(), 0xAAAAAA | Mth.ceil((float)(this.alpha * 255.0f)) << 24, false);
        }
    }
}

