/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.client.gui.journal;

import com.google.common.collect.ImmutableList;
import xyz.yfrostyf.toxony.client.gui.journal.PageScreen;

public class JournalPages {
    private ImmutableList<PageScreen> pages = ImmutableList.of();
    private int index = 0;

    public JournalPages fill(ImmutableList<PageScreen> pages, String translateId) {
        this.pages = pages;
        this.setPage(translateId);
        return this;
    }

    public PageScreen setPage(int index) {
        PageScreen page = (PageScreen)((Object)this.getPages().get(index));
        this.setIndex(index);
        return page;
    }

    public PageScreen setPage(String translateId) {
        int index = this.getPage(translateId);
        PageScreen page = (PageScreen)((Object)this.getPages().get(index));
        this.setIndex(index);
        return page;
    }

    public int getPage(String translateId) {
        return this.getPages().indexOf((Object)this.getPages().stream().filter(screen -> screen.translateID.matches(translateId)).findFirst().orElseThrow(() -> new NullPointerException("Journal could not find page with " + translateId + " as the page doesn't exist")));
    }

    public PageScreen getPageByString(String translateId) {
        return this.getPages().stream().filter(screen -> screen.translateID.matches(translateId)).findFirst().orElseThrow(() -> new NullPointerException("Journal could not find page with " + translateId + " as the page doesn't exist"));
    }

    public PageScreen updatePage() {
        PageScreen page = (PageScreen)((Object)this.getPages().get(this.index));
        page.openScreen();
        return page;
    }

    public ImmutableList<PageScreen> getPages() {
        return this.pages;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean hasNext() {
        return this.index + 1 < this.pages.size();
    }
}

