/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.client.gui.journal;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import xyz.yfrostyf.toxony.api.affinity.Affinity;
import xyz.yfrostyf.toxony.client.gui.journal.GraftingPageScreen;
import xyz.yfrostyf.toxony.client.gui.journal.ImagePageScreen;
import xyz.yfrostyf.toxony.client.gui.journal.IndexPageScreen;
import xyz.yfrostyf.toxony.client.gui.journal.JournalPages;
import xyz.yfrostyf.toxony.client.gui.journal.PageScreen;
import xyz.yfrostyf.toxony.client.gui.journal.TextAlembicPageScreen;
import xyz.yfrostyf.toxony.client.gui.journal.TextCraftingPageScreen;
import xyz.yfrostyf.toxony.client.gui.journal.TextCruciblePageScreen;
import xyz.yfrostyf.toxony.client.gui.journal.TextImagePageScreen;
import xyz.yfrostyf.toxony.client.gui.journal.TextMortarPageScreen;
import xyz.yfrostyf.toxony.client.gui.journal.TextPageScreen;
import xyz.yfrostyf.toxony.client.gui.journal.TextSingleItemTopScreen;

public class JournalPagesBuilder {
    List<PageScreen> pages = new ArrayList<PageScreen>();
    JournalPages emptyJournal = new JournalPages();
    int indexCount = 0;

    public JournalPagesBuilder IndexPageScreen(String translateId, Map<String, String> indexedPages) {
        this.pages.add(new IndexPageScreen(translateId, indexedPages, this.indexCount, this.emptyJournal));
        ++this.indexCount;
        return this;
    }

    public JournalPagesBuilder ImagePageScreen(String translateId, String locationId) {
        this.pages.add(new ImagePageScreen(translateId, locationId, this.indexCount, this.emptyJournal));
        ++this.indexCount;
        return this;
    }

    public JournalPagesBuilder TextSingleItemTopScreen(String translateId, ItemLike itemLike) {
        this.pages.add(new TextSingleItemTopScreen(translateId, this.indexCount, new ItemStack(itemLike), this.emptyJournal));
        ++this.indexCount;
        return this;
    }

    public JournalPagesBuilder TextSingleItemTopScreen(String translateId, ItemStack itemLike) {
        this.pages.add(new TextSingleItemTopScreen(translateId, this.indexCount, itemLike, this.emptyJournal));
        ++this.indexCount;
        return this;
    }

    public JournalPagesBuilder TextPageScreen(String translateId) {
        this.pages.add(new TextPageScreen(translateId, this.indexCount, this.emptyJournal));
        ++this.indexCount;
        return this;
    }

    public JournalPagesBuilder TextImagePageScreen(String translateId, String translateImageID) {
        this.pages.add(new TextImagePageScreen(translateId, translateImageID, this.indexCount, this.emptyJournal));
        ++this.indexCount;
        return this;
    }

    public JournalPagesBuilder TextCraftingPageScreen(String translateId, Item output, List<List<Item>> inputs) {
        this.pages.add(new TextCraftingPageScreen(translateId, output.getDefaultInstance(), JournalPagesBuilder.ListItemToItemStack(inputs), this.indexCount, this.emptyJournal));
        ++this.indexCount;
        return this;
    }

    public JournalPagesBuilder TextCraftingPageScreenStacks(String translateId, Item output, List<List<ItemStack>> inputs) {
        this.pages.add(new TextCraftingPageScreen(translateId, output.getDefaultInstance(), inputs, this.indexCount, this.emptyJournal));
        ++this.indexCount;
        return this;
    }

    public JournalPagesBuilder TextCraftingPageScreen(String translateId, ItemStack output, List<List<Item>> inputs) {
        this.pages.add(new TextCraftingPageScreen(translateId, output, JournalPagesBuilder.ListItemToItemStack(inputs), this.indexCount, this.emptyJournal));
        ++this.indexCount;
        return this;
    }

    public JournalPagesBuilder TextCraftingPageScreenIngredients(String translateId, Item output, List<Ingredient> inputs) {
        this.pages.add(new TextCraftingPageScreen(translateId, output.getDefaultInstance(), JournalPagesBuilder.ListIngredientsToItemStack(inputs), this.indexCount, this.emptyJournal));
        ++this.indexCount;
        return this;
    }

    public JournalPagesBuilder TextCraftingPageScreenItem(String translateId, Item output, List<Item> inputs) {
        ArrayList<List<Item>> newList = new ArrayList<List<Item>>();
        for (Item item : inputs) {
            newList.add(List.of(item));
        }
        return this.TextCraftingPageScreen(translateId, output, newList);
    }

    public JournalPagesBuilder TextCraftingPageScreenStack(String translateId, Item output, List<ItemStack> inputs) {
        ArrayList<List<ItemStack>> newList = new ArrayList<List<ItemStack>>();
        for (ItemStack item : inputs) {
            newList.add(List.of(item));
        }
        return this.TextCraftingPageScreenStacks(translateId, output, newList);
    }

    public JournalPagesBuilder TextMortarPageScreen(String translateId, Item output, Optional<RecipeHolder<?>> recipeHolder) {
        if (recipeHolder.isPresent()) {
            this.pages.add(new TextMortarPageScreen(translateId, output.getDefaultInstance(), JournalPagesBuilder.ListIngredientsToItemStack((List<Ingredient>)recipeHolder.get().value().getIngredients()), this.indexCount, this.emptyJournal));
        } else {
            this.pages.add(new TextSingleItemTopScreen(translateId, this.indexCount, output.getDefaultInstance(), this.emptyJournal));
        }
        ++this.indexCount;
        return this;
    }

    public JournalPagesBuilder TextCruciblePageScreen(String translateId, Item output, Optional<RecipeHolder<?>> recipeHolder) {
        if (recipeHolder.isPresent()) {
            this.pages.add(new TextCruciblePageScreen(translateId, output.getDefaultInstance(), Arrays.asList(((Ingredient)recipeHolder.get().value().getIngredients().getFirst()).getItems()), this.indexCount, this.emptyJournal));
        } else {
            this.pages.add(new TextSingleItemTopScreen(translateId, this.indexCount, output.getDefaultInstance(), this.emptyJournal));
        }
        ++this.indexCount;
        return this;
    }

    public JournalPagesBuilder TextAlembicPageScreen(String translateId, Item output, Optional<RecipeHolder<?>> recipeHolder) {
        if (recipeHolder.isPresent()) {
            this.pages.add(new TextAlembicPageScreen(translateId, output.getDefaultInstance(), JournalPagesBuilder.ListIngredientsToItemStack(List.of((Ingredient)recipeHolder.get().value().getIngredients().get(0), (Ingredient)recipeHolder.get().value().getIngredients().get(1))), this.indexCount, this.emptyJournal));
        } else {
            this.pages.add(new TextSingleItemTopScreen(translateId, this.indexCount, output.getDefaultInstance(), this.emptyJournal));
        }
        ++this.indexCount;
        return this;
    }

    public JournalPagesBuilder GraftingPageScreen(String translateId, Map<Pair<ItemStack, ItemStack>, Affinity> inputs) {
        this.pages.add(new GraftingPageScreen(translateId, inputs, this.indexCount, this.emptyJournal));
        ++this.indexCount;
        return this;
    }

    public JournalPages build(String translateId) {
        return this.emptyJournal.fill((ImmutableList<PageScreen>)ImmutableList.copyOf(this.pages), translateId);
    }

    public static List<List<ItemStack>> ListItemToItemStack(List<List<Item>> inputs) {
        ArrayList<List<ItemStack>> newList = new ArrayList<List<ItemStack>>();
        for (List<Item> inputItem : inputs) {
            newList.add(inputItem.stream().map(Item::getDefaultInstance).toList());
        }
        return newList;
    }

    public static List<List<ItemStack>> ListIngredientsToItemStack(List<Ingredient> inputs) {
        ArrayList<List<ItemStack>> newList = new ArrayList<List<ItemStack>>();
        for (Ingredient inputItem : inputs) {
            newList.add(Arrays.asList(inputItem.getItems()));
        }
        return newList;
    }
}

