/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.client.gui.journal;

import com.mojang.datafixers.util.Pair;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import xyz.yfrostyf.toxony.api.affinity.Affinity;
import xyz.yfrostyf.toxony.client.gui.journal.JournalPages;
import xyz.yfrostyf.toxony.client.gui.journal.JournalPagesBuilder;
import xyz.yfrostyf.toxony.data.datagen.enchantments.ToxonyEnchantments;
import xyz.yfrostyf.toxony.registries.AffinityRegistry;
import xyz.yfrostyf.toxony.registries.ItemRegistry;

public class JournalUtil {
    public static String lastPageID = "journal.toxony.page.cover";
    private static final Item EMPTY = Items.AIR;
    private static final Level level = Minecraft.getInstance().level;
    private static final RecipeManager manager = level != null ? level.getRecipeManager() : null;

    public static void startPage() {
        JournalPages pages = JournalUtil.createPages().build(lastPageID);
        pages.updatePage();
    }

    public static void setLastPageID(String id) {
        lastPageID = id;
    }

    public static Map<String, String> createIndexMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("Poison Basics", "journal.toxony.page.poison_basics.cover");
        map.put("Poisonous Flora", "journal.toxony.page.poisonous_flora.cover");
        map.put("Oil Basics", "journal.toxony.page.oil_basics.cover");
        map.put("Basic Tools", "journal.toxony.page.basic_tools.cover");
        map.put("Refined Process", "journal.toxony.page.refined_process.cover");
        map.put("Alchemical Warfare", "journal.toxony.page.alchemical_warfare.cover");
        map.put("Pure Chemistry", "journal.toxony.page.pure_chemistry.cover");
        map.put("Mutagens", "journal.toxony.page.mutagens.cover");
        map.put("Evolved Flora", "journal.toxony.page.evolved_flora.cover");
        map.put("Advanced Oils", "journal.toxony.page.advanced_oils.cover");
        map.put("Evolving Warfare", "journal.toxony.page.evolving_warfare.cover");
        map.put("Lost Chemistry", "journal.toxony.page.lost_chemistry.cover");
        return map;
    }

    public static JournalPagesBuilder createPages() {
        Optional<RecipeHolder<?>> recipe_toxic_paste = JournalUtil.getRecipe(manager, "crucible/toxic_paste");
        return new JournalPagesBuilder().ImagePageScreen("journal.toxony.page.cover", "textures/gui/journal/journal_cover.png").TextPageScreen("journal.toxony.page.introduction.0").TextPageScreen("journal.toxony.page.introduction.1").IndexPageScreen("journal.toxony.page.index.0", JournalUtil.createIndexMap()).ImagePageScreen("journal.toxony.page.poison_basics.cover", "textures/gui/journal/journal_poison_basics_cover.png").TextPageScreen("journal.toxony.page.poison_basics.0").TextCraftingPageScreenItem("journal.toxony.page.poison_basics.1", (Item)ItemRegistry.MORTAR_PESTLE.get(), List.of(EMPTY, EMPTY, EMPTY, Items.STONE, Items.STICK, Items.STONE, Items.STONE, Items.STONE, Items.STONE)).TextPageScreen("journal.toxony.page.poison_basics.2").TextPageScreen("journal.toxony.page.poison_basics.3").TextMortarPageScreen("journal.toxony.page.poison_basics.4", (Item)ItemRegistry.POISON_PASTE.get(), JournalUtil.getRecipe(manager, "mortar/poison_paste")).TextPageScreen("journal.toxony.page.poison_basics.5").ImagePageScreen("journal.toxony.page.poisonous_flora.cover", "textures/gui/journal/journal_poisonous_flora_cover.png").TextSingleItemTopScreen("journal.toxony.page.poisonous_flora.0", (ItemLike)ItemRegistry.OCELOT_MINT.get()).TextSingleItemTopScreen("journal.toxony.page.poisonous_flora.1", (ItemLike)ItemRegistry.NIGHTSHADE.get()).TextSingleItemTopScreen("journal.toxony.page.poisonous_flora.2", (ItemLike)ItemRegistry.WATER_HEMLOCK.get()).TextSingleItemTopScreen("journal.toxony.page.poisonous_flora.3", (ItemLike)ItemRegistry.COLDSNAP.get()).TextSingleItemTopScreen("journal.toxony.page.poisonous_flora.4", (ItemLike)ItemRegistry.BLOODROOT.get()).TextSingleItemTopScreen("journal.toxony.page.poisonous_flora.5", (ItemLike)ItemRegistry.POISON_FARMLAND.get()).TextPageScreen("journal.toxony.page.poisonous_flora.6").TextSingleItemTopScreen("journal.toxony.page.poisonous_flora.7", (ItemLike)ItemRegistry.VENOM_TOOTH.get()).TextSingleItemTopScreen("journal.toxony.page.poisonous_flora.8", (ItemLike)ItemRegistry.TOXIC_SPIT.get()).TextSingleItemTopScreen("journal.toxony.page.poisonous_flora.9", (ItemLike)ItemRegistry.POISON_SAC.get()).TextSingleItemTopScreen("journal.toxony.page.poisonous_flora.10", (ItemLike)ItemRegistry.BOG_BONE.get()).TextSingleItemTopScreen("journal.toxony.page.poisonous_flora.11", (ItemLike)ItemRegistry.ACID_SLIMEBALL.get()).TextPageScreen("journal.toxony.page.poisonous_flora.12").TextMortarPageScreen("journal.toxony.page.poisonous_flora.13", (Item)ItemRegistry.POISON_BLEND.get(), JournalUtil.getRecipe(manager, "mortar/poison_blend")).TextPageScreen("journal.toxony.page.poisonous_flora.14").ImagePageScreen("journal.toxony.page.oil_basics.cover", "textures/gui/journal/journal_oil_basics_cover.png").TextPageScreen("journal.toxony.page.oil_basics.0").TextCraftingPageScreenItem("journal.toxony.page.oil_basics.1", (Item)ItemRegistry.CLAY_OIL_POT.get(), List.of(EMPTY, EMPTY, EMPTY, Items.CLAY_BALL, (Item)ItemRegistry.POISON_PASTE.get(), Items.CLAY_BALL, EMPTY, Items.CLAY_BALL, EMPTY)).TextMortarPageScreen("journal.toxony.page.oil_basics.2", (Item)ItemRegistry.POISON_OIL_POT.get(), JournalUtil.getRecipe(manager, "mortar/poison_oil_pot")).TextMortarPageScreen("journal.toxony.page.oil_basics.3", (Item)ItemRegistry.FATIGUE_OIL_POT.get(), JournalUtil.getRecipe(manager, "mortar/fatigue_oil_pot")).TextMortarPageScreen("journal.toxony.page.oil_basics.4", (Item)ItemRegistry.GLOWING_OIL_POT.get(), JournalUtil.getRecipe(manager, "mortar/glowing_oil_pot")).TextMortarPageScreen("journal.toxony.page.oil_basics.5", (Item)ItemRegistry.FIRE_RESISTANCE_OIL_POT.get(), JournalUtil.getRecipe(manager, "mortar/fire_resistance_oil_pot")).TextPageScreen("journal.toxony.page.oil_basics.6").ImagePageScreen("journal.toxony.page.basic_tools.cover", "textures/gui/journal/journal_basic_tools_cover.png").TextPageScreen("journal.toxony.page.basic_tools.0").TextCraftingPageScreenItem("journal.toxony.page.basic_tools.1", (Item)ItemRegistry.TOX_GAUGE.get(), List.of(EMPTY, (Item)ItemRegistry.POISON_PASTE.get(), EMPTY, Items.COPPER_INGOT, Items.REDSTONE, Items.COPPER_INGOT, EMPTY, (Item)ItemRegistry.POISON_PASTE.get(), EMPTY)).TextImagePageScreen("journal.toxony.page.basic_tools.2", "textures/gui/journal/journal_gauge_image.png").TextImagePageScreen("journal.toxony.page.basic_tools.3", "textures/gui/journal/journal_toxin_gauge_image.png").TextImagePageScreen("journal.toxony.page.basic_tools.4", "textures/gui/journal/journal_tolerance_gauge_image.png").TextImagePageScreen("journal.toxony.page.basic_tools.5", "textures/gui/journal/journal_tolerance_gauge_image.png").TextImagePageScreen("journal.toxony.page.basic_tools.6", "textures/gui/journal/journal_death_gauge_image.png").TextPageScreen("journal.toxony.page.basic_tools.7").TextCraftingPageScreenItem("journal.toxony.page.basic_tools.8", (Item)ItemRegistry.COPPER_SCALPEL.get(), List.of(EMPTY, Items.COPPER_INGOT, EMPTY, EMPTY, Items.IRON_NUGGET, EMPTY, EMPTY, Items.IRON_NUGGET, EMPTY)).TextCraftingPageScreenItem("journal.toxony.page.basic_tools.9", (Item)ItemRegistry.MAGNIFYING_GLASS.get(), List.of(Items.COPPER_INGOT, Items.GLASS_PANE, Items.COPPER_INGOT, EMPTY, Items.STICK, EMPTY, EMPTY, Items.STICK, EMPTY)).ImagePageScreen("journal.toxony.page.refined_process.cover", "textures/gui/journal/journal_refined_process_cover.png").TextPageScreen("journal.toxony.page.refined_process.0").TextCraftingPageScreenItem("journal.toxony.page.refined_process.1", (Item)ItemRegistry.COPPER_CRUCIBLE.get(), List.of(EMPTY, Items.COPPER_INGOT, EMPTY, Items.COPPER_INGOT, Items.COPPER_INGOT, Items.COPPER_INGOT, Items.IRON_INGOT, Items.CHARCOAL, Items.IRON_INGOT)).TextCruciblePageScreen("journal.toxony.page.refined_process.2", (Item)ItemRegistry.TOXIC_PASTE.get(), JournalUtil.getRecipe(manager, "crucible/toxic_paste")).TextPageScreen("journal.toxony.page.refined_process.3").TextMortarPageScreen("journal.toxony.page.refined_process.4", (Item)ItemRegistry.ACID_OIL_POT.get(), JournalUtil.getRecipe(manager, "mortar/acid_oil_pot")).TextMortarPageScreen("journal.toxony.page.refined_process.5", (Item)ItemRegistry.MENDING_OIL_POT.get(), JournalUtil.getRecipe(manager, "mortar/mending_oil_pot")).TextMortarPageScreen("journal.toxony.page.refined_process.6", (Item)ItemRegistry.TOXIC_BLEND.get(), JournalUtil.getRecipe(manager, "mortar/toxic_blend")).TextCraftingPageScreenItem("journal.toxony.page.refined_process.7", (Item)ItemRegistry.REDSTONE_MORTAR.get(), List.of(Items.CHISELED_POLISHED_BLACKSTONE, (Item)ItemRegistry.MORTAR_PESTLE.get(), Items.CHISELED_POLISHED_BLACKSTONE, Items.COPPER_INGOT, Items.IRON_INGOT, Items.COPPER_INGOT, Items.COPPER_INGOT, Items.COMPARATOR, Items.COPPER_INGOT)).TextPageScreen("journal.toxony.page.refined_process.8").ImagePageScreen("journal.toxony.page.alchemical_warfare.cover", "textures/gui/journal/journal_alchemical_warfare_cover.png").TextCraftingPageScreenItem("journal.toxony.page.alchemical_warfare.0", (Item)ItemRegistry.OIL_POT_SASH.get(), List.of(EMPTY, EMPTY, Items.LEATHER, EMPTY, Items.IRON_INGOT, (Item)ItemRegistry.EMPTY_OIL_POT.get(), Items.LEATHER, (Item)ItemRegistry.EMPTY_OIL_POT.get(), EMPTY)).TextPageScreen("journal.toxony.page.alchemical_warfare.1").TextCraftingPageScreenItem("journal.toxony.page.alchemical_warfare.2", (Item)ItemRegistry.CYCLEBOW.get(), List.of(Items.COPPER_INGOT, (Item)ItemRegistry.POISON_PASTE.get(), Items.COPPER_INGOT, Items.STRING, Items.TRIPWIRE_HOOK, Items.STRING, EMPTY, Items.COPPER_INGOT, EMPTY)).TextCraftingPageScreenItem("journal.toxony.page.alchemical_warfare.3", (Item)ItemRegistry.BOLT.get(), List.of(EMPTY, Items.FLINT, EMPTY, EMPTY, Items.IRON_NUGGET, EMPTY, EMPTY, Items.IRON_NUGGET, EMPTY)).TextPageScreen("journal.toxony.page.alchemical_warfare.4").TextCraftingPageScreenItem("journal.toxony.page.alchemical_warfare.5", (Item)ItemRegistry.BOLT_CARTRIDGE.get(), List.of(EMPTY, EMPTY, EMPTY, EMPTY, Items.LEATHER, EMPTY, Items.STRING, Items.COPPER_INGOT, Items.STRING)).TextPageScreen("journal.toxony.page.alchemical_warfare.6").TextPageScreen("journal.toxony.page.alchemical_warfare.7").TextCraftingPageScreenItem("journal.toxony.page.alchemical_warfare.8", (Item)ItemRegistry.POTION_FLASK.get(), List.of(EMPTY, (Item)ItemRegistry.TOXIC_PASTE.get(), EMPTY, Items.LEATHER, Items.GLASS_BOTTLE, Items.LEATHER, EMPTY, Items.LEATHER, EMPTY)).TextPageScreen("journal.toxony.page.alchemical_warfare.9").TextSingleItemTopScreen("journal.toxony.page.alchemical_warfare.10", JournalUtil.createEnchantedItemStack(Items.ENCHANTED_BOOK, ToxonyEnchantments.REFILL)).ImagePageScreen("journal.toxony.page.pure_chemistry.cover", "textures/gui/journal/journal_pure_chemistry_cover.png").TextPageScreen("journal.toxony.page.pure_chemistry.0").TextCraftingPageScreenItem("journal.toxony.page.pure_chemistry.1", (Item)ItemRegistry.GLASS_VIAL.get(), List.of(EMPTY, EMPTY, EMPTY, Items.GLASS, EMPTY, Items.GLASS, EMPTY, Items.QUARTZ, EMPTY)).TextCraftingPageScreenItem("journal.toxony.page.pure_chemistry.2", (Item)ItemRegistry.TOXIN_CANISTER.get(), List.of(Items.COPPER_INGOT, (Item)ItemRegistry.TOXIC_PASTE.get(), Items.COPPER_INGOT, Items.COPPER_INGOT, (Item)ItemRegistry.GLASS_VIAL.get(), Items.COPPER_INGOT, Items.COPPER_INGOT, (Item)ItemRegistry.TOXIC_PASTE.get(), Items.COPPER_INGOT)).TextCraftingPageScreenItem("journal.toxony.page.pure_chemistry.3", (Item)ItemRegistry.ALEMBIC.get(), List.of(Items.COPPER_INGOT, EMPTY, EMPTY, Items.COPPER_INGOT, Items.IRON_INGOT, EMPTY, (Item)ItemRegistry.ALEMBIC_BASE.get(), EMPTY, (Item)ItemRegistry.TOXIN_CANISTER.get())).TextCraftingPageScreenItem("journal.toxony.page.pure_chemistry.4", (Item)ItemRegistry.ALEMBIC_BASE.get(), List.of(EMPTY, Items.IRON_INGOT, EMPTY, Items.COPPER_INGOT, (Item)ItemRegistry.TOXIN_CANISTER.get(), Items.COPPER_INGOT, Items.COPPER_INGOT, Items.COPPER_INGOT, Items.COPPER_INGOT)).TextPageScreen("journal.toxony.page.pure_chemistry.5").TextPageScreen("journal.toxony.page.pure_chemistry.6").TextCraftingPageScreenStack("journal.toxony.page.pure_chemistry.7", (Item)ItemRegistry.TOXIC_FORMULA.get(), List.of(Items.NETHER_WART.getDefaultInstance(), PotionContents.createItemStack((Item)((Item)ItemRegistry.TOX_VIAL.get()), (Holder)Potions.WATER), EMPTY.getDefaultInstance(), new ItemStack((ItemLike)ItemRegistry.TOXIC_PASTE.get()), EMPTY.getDefaultInstance(), EMPTY.getDefaultInstance(), EMPTY.getDefaultInstance(), EMPTY.getDefaultInstance(), EMPTY.getDefaultInstance())).TextPageScreen("journal.toxony.page.pure_chemistry.8").TextAlembicPageScreen("journal.toxony.page.pure_chemistry.9", (Item)ItemRegistry.TOXIN.get(), JournalUtil.getRecipe(manager, "alembic/toxin")).ImagePageScreen("journal.toxony.page.mutagens.cover", "textures/gui/journal/journal_mutagens_cover.png").TextPageScreen("journal.toxony.page.mutagens.0").TextPageScreen("journal.toxony.page.mutagens.1").TextImagePageScreen("journal.toxony.page.mutagens.2", "textures/gui/journal/journal_full_gauge_image.png").TextPageScreen("journal.toxony.page.mutagens.3").TextPageScreen("journal.toxony.page.mutagens.4").TextPageScreen("journal.toxony.page.mutagens.5").TextCraftingPageScreenStack("journal.toxony.page.mutagens.6", (Item)ItemRegistry.REDSTONE_MIXTURE.get(), List.of(PotionContents.createItemStack((Item)((Item)ItemRegistry.TOX_VIAL.get()), (Holder)Potions.WATER), Items.REDSTONE.getDefaultInstance(), EMPTY.getDefaultInstance(), EMPTY.getDefaultInstance(), EMPTY.getDefaultInstance(), EMPTY.getDefaultInstance(), EMPTY.getDefaultInstance(), EMPTY.getDefaultInstance(), EMPTY.getDefaultInstance())).TextCruciblePageScreen("journal.toxony.page.mutagens.7", (Item)ItemRegistry.REDSTONE_SOLUTION.get(), JournalUtil.getRecipe(manager, "crucible/redstone_solution")).TextAlembicPageScreen("journal.toxony.page.mutagens.8", (Item)ItemRegistry.AFFINITY_SOLUTION.get(), JournalUtil.getRecipe(manager, "alembic/affinity_solution")).TextCraftingPageScreenItem("journal.toxony.page.mutagens.9", (Item)ItemRegistry.COPPER_NEEDLE.get(), List.of(EMPTY, EMPTY, Items.IRON_NUGGET, EMPTY, (Item)ItemRegistry.TOXIN_CANISTER.get(), EMPTY, Items.COPPER_INGOT, EMPTY, EMPTY)).TextPageScreen("journal.toxony.page.mutagens.10").TextPageScreen("journal.toxony.page.mutagens.11").TextPageScreen("journal.toxony.page.mutagens.12").ImagePageScreen("journal.toxony.page.evolved_flora.cover", "textures/gui/journal/journal_evolved_flora_cover.png").TextPageScreen("journal.toxony.page.evolved_flora.0").TextPageScreen("journal.toxony.page.evolved_flora.1").TextPageScreen("journal.toxony.page.evolved_flora.2").GraftingPageScreen("journal.toxony.page.evolved_flora.3", Map.of(new Pair((Object)new ItemStack(ItemRegistry.OCELOT_MINT), (Object)new ItemStack(ItemRegistry.SNOW_MINT)), (Affinity)AffinityRegistry.DECAY.get(), new Pair((Object)new ItemStack(ItemRegistry.NIGHTSHADE), (Object)new ItemStack(ItemRegistry.SUNSPOT)), (Affinity)AffinityRegistry.HEAT.get(), new Pair((Object)new ItemStack(ItemRegistry.WATER_HEMLOCK), (Object)new ItemStack(ItemRegistry.MOONLIGHT_HEMLOCK)), (Affinity)AffinityRegistry.FOREST.get(), new Pair((Object)new ItemStack(ItemRegistry.COLDSNAP), (Object)new ItemStack(ItemRegistry.WHIRLSNAP)), (Affinity)AffinityRegistry.OCEAN.get(), new Pair((Object)new ItemStack(ItemRegistry.BLOODROOT), (Object)new ItemStack(ItemRegistry.WARPROOT)), (Affinity)AffinityRegistry.COLD.get())).TextMortarPageScreen("journal.toxony.page.evolved_flora.3", (Item)ItemRegistry.AFFINITY_FUSION_MIX.get(), JournalUtil.getRecipe(manager, "mortar/affinity_fusion_mix")).TextCruciblePageScreen("journal.toxony.page.evolved_flora.4", (Item)ItemRegistry.UNKNOWN_SUBSTANCE.get(), JournalUtil.getRecipe(manager, "crucible/affinity_unknown_substance")).TextSingleItemTopScreen("journal.toxony.page.evolved_flora.5", (ItemLike)ItemRegistry.UNKNOWN_SUBSTANCE.get()).ImagePageScreen("journal.toxony.page.advanced_oils.cover", "textures/gui/journal/journal_advanced_oils_cover.png").TextPageScreen("journal.toxony.page.advanced_oils.0").TextAlembicPageScreen("journal.toxony.page.advanced_oils.1", (Item)ItemRegistry.EMPTY_TOX_POT.get(), JournalUtil.getRecipe(manager, "alembic/empty_tox_pot")).TextMortarPageScreen("journal.toxony.page.advanced_oils.2", (Item)ItemRegistry.TOXIN_TOX_POT.get(), JournalUtil.getRecipe(manager, "mortar/toxin_tox_pot")).TextMortarPageScreen("journal.toxony.page.advanced_oils.3", (Item)ItemRegistry.SMOKE_TOX_POT.get(), JournalUtil.getRecipe(manager, "mortar/smoke_tox_pot")).TextMortarPageScreen("journal.toxony.page.advanced_oils.4", (Item)ItemRegistry.REGENERATION_TOX_POT.get(), JournalUtil.getRecipe(manager, "mortar/regeneration_tox_pot")).TextMortarPageScreen("journal.toxony.page.advanced_oils.5", (Item)ItemRegistry.ACID_TOX_POT.get(), JournalUtil.getRecipe(manager, "mortar/acid_tox_pot")).TextMortarPageScreen("journal.toxony.page.advanced_oils.6", (Item)ItemRegistry.WITCHFIRE_TOX_POT.get(), JournalUtil.getRecipe(manager, "mortar/witchfire_tox_pot")).TextMortarPageScreen("journal.toxony.page.advanced_oils.7", (Item)ItemRegistry.OIL_BASE.get(), JournalUtil.getRecipe(manager, "mortar/oil_base")).ImagePageScreen("journal.toxony.page.evolving_warfare.cover", "textures/gui/journal/journal_evolving_warfare_cover.png").TextPageScreen("journal.toxony.page.evolving_warfare.0").TextAlembicPageScreen("journal.toxony.page.evolving_warfare.1", (Item)ItemRegistry.TOXIC_LEATHER.get(), JournalUtil.getRecipe(manager, "alembic/toxic_leather")).TextCraftingPageScreenItem("journal.toxony.page.evolving_warfare.2", (Item)ItemRegistry.PLAGUE_DOCTOR_COAT.get(), List.of(Items.CHAIN, EMPTY, Items.CHAIN, (Item)ItemRegistry.TOXIC_LEATHER.get(), (Item)ItemRegistry.TOXIC_LEATHER.get(), (Item)ItemRegistry.TOXIC_LEATHER.get(), (Item)ItemRegistry.GLASS_VIAL.get(), (Item)ItemRegistry.TOXIC_LEATHER.get(), (Item)ItemRegistry.GLASS_VIAL.get())).TextCraftingPageScreenItem("journal.toxony.page.evolving_warfare.3", (Item)ItemRegistry.PLAGUE_DOCTOR_LEGGINGS.get(), List.of(Items.CHAIN, Items.LEATHER, Items.CHAIN, (Item)ItemRegistry.TOXIC_LEATHER.get(), EMPTY, (Item)ItemRegistry.TOXIC_LEATHER.get(), (Item)ItemRegistry.TOXIC_LEATHER.get(), EMPTY, (Item)ItemRegistry.TOXIC_LEATHER.get())).TextCraftingPageScreenItem("journal.toxony.page.evolving_warfare.4", (Item)ItemRegistry.PLAGUE_DOCTOR_BOOTS.get(), List.of(EMPTY, EMPTY, EMPTY, (Item)ItemRegistry.TOXIC_LEATHER.get(), EMPTY, (Item)ItemRegistry.TOXIC_LEATHER.get(), Items.LEATHER, EMPTY, Items.LEATHER)).TextCraftingPageScreenItem("journal.toxony.page.evolving_warfare.5", (Item)ItemRegistry.PLAGUE_DOCTOR_HOOD.get(), List.of(EMPTY, (Item)ItemRegistry.TOXIC_LEATHER.get(), EMPTY, (Item)ItemRegistry.TOXIC_LEATHER.get(), EMPTY, (Item)ItemRegistry.TOXIC_LEATHER.get(), (Item)ItemRegistry.TOXIC_LEATHER.get(), Items.CHAIN, (Item)ItemRegistry.TOXIC_LEATHER.get())).TextPageScreen("journal.toxony.page.evolving_warfare.6").TextPageScreen("journal.toxony.page.evolving_warfare.7").TextCraftingPageScreenItem("journal.toxony.page.evolving_warfare.8", (Item)ItemRegistry.OIL_POT_BANDOLIER.get(), List.of(EMPTY, EMPTY, (Item)ItemRegistry.TOXIC_LEATHER.get(), EMPTY, Items.NETHERITE_INGOT, (Item)ItemRegistry.EMPTY_TOX_POT.get(), (Item)ItemRegistry.TOXIC_LEATHER.get(), (Item)ItemRegistry.EMPTY_TOX_POT.get(), EMPTY)).TextCraftingPageScreenItem("journal.toxony.page.evolving_warfare.9", (Item)ItemRegistry.TOXIN_FLASK.get(), List.of(Items.QUARTZ, Items.NETHERITE_INGOT, Items.QUARTZ, (Item)ItemRegistry.TOXIC_LEATHER.get(), Items.GLASS_BOTTLE, (Item)ItemRegistry.TOXIC_LEATHER.get(), EMPTY, (Item)ItemRegistry.TOXIC_LEATHER.get(), EMPTY)).ImagePageScreen("journal.toxony.page.lost_chemistry.cover", "textures/gui/journal/journal_lost_chemistry_cover.png").TextPageScreen("journal.toxony.page.lost_chemistry.0").TextCraftingPageScreenItem("journal.toxony.page.lost_chemistry.1", (Item)ItemRegistry.ALCHEMICAL_FORGE_PART.get(), List.of((Item)ItemRegistry.TOXIN.get(), Items.NETHERITE_INGOT, (Item)ItemRegistry.TOXIN.get(), (Item)ItemRegistry.TOXIN_CANISTER.get(), Items.COPPER_BLOCK, (Item)ItemRegistry.TOXIN_CANISTER.get(), Items.CHISELED_POLISHED_BLACKSTONE, Items.CHISELED_POLISHED_BLACKSTONE, Items.CHISELED_POLISHED_BLACKSTONE)).TextPageScreen("journal.toxony.page.lost_chemistry.2");
    }

    private static Optional<RecipeHolder<?>> getRecipe(RecipeManager manager, String location) {
        Optional optional = Optional.empty();
        if (level != null) {
            optional = manager.byKey(ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)location));
        }
        return optional;
    }

    private static ItemStack createEnchantedItemStack(Item itemStack, ResourceKey<Enchantment> key) {
        if (Minecraft.getInstance().getConnection() == null) {
            return ItemStack.EMPTY;
        }
        Holder.Reference holder = Minecraft.getInstance().getConnection().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(key);
        ItemStack stack = new ItemStack((ItemLike)itemStack);
        ItemEnchantments.Mutable enchantmentMutable = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        enchantmentMutable.set((Holder)holder, 1);
        EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)enchantmentMutable.toImmutable());
        return stack;
    }
}

