/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.client.gui.journal;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import xyz.yfrostyf.toxony.client.gui.journal.IndexPageScreen;
import xyz.yfrostyf.toxony.client.gui.journal.JournalPages;
import xyz.yfrostyf.toxony.client.gui.journal.JournalUtil;

public abstract class PageScreen
extends Screen {
    protected final String translateID;
    protected JournalPages journalPages;
    protected int indexID;

    public PageScreen(String translateID, int indexID, JournalPages journalPages) {
        super((Component)Component.empty());
        this.minecraft = Minecraft.getInstance();
        this.translateID = translateID;
        this.indexID = indexID;
        this.journalPages = journalPages;
    }

    public int getIndexID() {
        return this.indexID;
    }

    protected void init() {
        super.init();
        if (this.journalPages.hasNext()) {
            this.addRenderableWidget((GuiEventListener)new PageSwitchButton(this, true));
        }
        if (this.journalPages.getIndex() > 0) {
            this.addRenderableWidget((GuiEventListener)new PageSwitchButton(this, false));
        }
        if (!(this instanceof IndexPageScreen)) {
            this.addRenderableWidget((GuiEventListener)new IndexTabButton(this));
        }
    }

    public void nextPage() {
        if (this.journalPages.hasNext()) {
            this.journalPages.setIndex(this.journalPages.getIndex() + 1);
            this.journalPages.updatePage();
        }
    }

    public void previousPage() {
        if (this.journalPages.getIndex() > 0) {
            this.journalPages.setIndex(this.journalPages.getIndex() - 1);
            this.journalPages.updatePage();
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == Minecraft.getInstance().options.keyInventory.getKey().getValue() || keyCode == 69 || keyCode == 81) {
            this.closeScreen();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    protected void openScreen() {
        this.minecraft.setScreen((Screen)this);
    }

    protected void closeScreen() {
        JournalUtil.setLastPageID(this.translateID);
        this.onClose();
    }

    public void onClose() {
        JournalUtil.setLastPageID(this.translateID);
        super.onClose();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static class PageSwitchButton
    extends AbstractButton {
        static final ResourceLocation BUTTON_LEFT_RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"journal/left_button");
        static final ResourceLocation BUTTONS_RIGHT_RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"journal/right_button");
        private final PageScreen screen;
        private final boolean isForward;
        private static final int BUTTON_OFFSETX = 75;
        private static final int BUTTON_OFFSETY = -6;
        private static final int BUTTON_TEXTURE_WIDTH = 18;
        private static final int BUTTON_TEXTURE_HEIGHT = 109;

        protected PageSwitchButton(PageScreen screen, boolean isForward) {
            super(isForward ? (screen.width - 18) / 2 + 75 : (screen.width - 18) / 2 - 75, (screen.height - 109) / 2 + -6, 18, 109, CommonComponents.EMPTY);
            this.screen = screen;
            this.isForward = isForward;
        }

        public void onPress() {
            if (!this.active) {
                return;
            }
            if (this.isForward) {
                this.screen.nextPage();
                return;
            }
            this.screen.previousPage();
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            int halfScreenWidth = (guiGraphics.guiWidth() - 18) / 2;
            int halfScreenHeight = (guiGraphics.guiHeight() - 109) / 2;
            int posX = this.isForward ? halfScreenWidth + 75 : halfScreenWidth - 75;
            int posY = halfScreenHeight + -6;
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            if (this.isForward) {
                if (this.isHoveredOrFocused()) {
                    guiGraphics.blitSprite(BUTTONS_RIGHT_RESOURCE, 18, 109, 0, 0, posX, posY, 18, 109);
                }
            } else if (this.isHoveredOrFocused()) {
                guiGraphics.blitSprite(BUTTON_LEFT_RESOURCE, 18, 109, 0, 0, posX, posY, 18, 109);
            }
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
        }

        public void playDownSound(SoundManager handler) {
            handler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)0.8f));
        }

        public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            this.defaultButtonNarrationText(narrationElementOutput);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static class IndexTabButton
    extends AbstractButton {
        static final ResourceLocation INDEX_BUTTON = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"journal/index_tab_button");
        private final PageScreen screen;
        private float posY1;
        private static final int BUTTON_OFFSETX = -60;
        private static final int BUTTON_OFFSETY = -120;
        private static final int BUTTON_HOVER_OFFSETY = 20;
        private static final int BUTTON_TEXTURE_WIDTH = 25;
        private static final int BUTTON_TEXTURE_HEIGHT = 25;

        protected IndexTabButton(PageScreen screen) {
            super((screen.width - 25) / 2 + -60, (screen.height - 25) / 2 + -120, 25, 25, CommonComponents.EMPTY);
            this.screen = screen;
            this.posY1 = this.getY() + 20;
        }

        public void onPress() {
            if (!this.active) {
                return;
            }
            this.screen.journalPages.setPage("journal.toxony.page.index.0");
            this.screen.journalPages.updatePage();
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            int posX = this.getX();
            int posY = this.getY();
            this.posY1 = this.isHoveredOrFocused() ? (this.posY1 -= 0.59999996f) : (this.posY1 += 0.59999996f);
            int buttonHeight = 25 - Mth.floor((float)(20.0f * Mth.clamp((float)((this.posY1 - (float)posY) / 20.0f), (float)0.0f, (float)1.0f)));
            if (this.posY1 < (float)posY) {
                this.posY1 = posY;
            }
            if (this.posY1 > (float)(posY + 20)) {
                this.posY1 = posY + 20;
            }
            guiGraphics.blitSprite(INDEX_BUTTON, 25, 25, 0, 0, posX, Mth.floor((float)this.posY1), 25, buttonHeight);
        }

        public void playDownSound(SoundManager handler) {
            handler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)0.8f));
        }

        public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            this.defaultButtonNarrationText(narrationElementOutput);
        }
    }
}

