/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.client.gui.journal;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import xyz.yfrostyf.toxony.client.gui.journal.JournalPages;
import xyz.yfrostyf.toxony.client.gui.journal.TextPageScreen;
import xyz.yfrostyf.toxony.client.utils.ClientUtil;

public class TextAlembicPageScreen
extends TextPageScreen {
    private static final ResourceLocation ALEMBIC_IMAGE = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"textures/gui/journal/journal_alembic_menu.png");
    private final ItemStack outputItem;
    private final List<List<ItemStack>> inputItems;

    public TextAlembicPageScreen(String translateID, ItemStack outputItem, List<List<ItemStack>> inputItems, int indexID, JournalPages journalPages) {
        super(translateID, indexID, journalPages);
        this.inputItems = inputItems;
        this.outputItem = outputItem;
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int backgroundPosX = (this.width - 203) / 2;
        int backgroundPosY = (this.height - 237) / 2;
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.blit(ALEMBIC_IMAGE, backgroundPosX, backgroundPosY, 0, 0, 203, 237);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int halfScreenPosX = this.width / 2;
        int halfScreenPosY = this.height / 2;
        int posX = halfScreenPosX - 30;
        int posY = halfScreenPosY + 48 + 17;
        for (int i = 0; i < 2; ++i) {
            ItemStack stack;
            if (this.inputItems.size() <= i) continue;
            boolean isMainSlot = i == 0;
            List<ItemStack> ingredients = this.inputItems.get(i);
            if (ingredients.size() == 1) {
                stack = ingredients.getFirst();
            } else {
                if (ingredients.size() <= 1) continue;
                stack = ingredients.get((int)((long)ClientUtil.getClientTick() % (20L * (long)ingredients.size()) / 20L));
            }
            if (stack.isEmpty()) continue;
            int itemPosX = isMainSlot ? posX : posX + 36;
            int itemPosY = isMainSlot ? posY : posY - 5;
            guiGraphics.renderItem(stack, itemPosX, itemPosY);
            guiGraphics.renderItemDecorations(this.minecraft.font, stack, itemPosX, itemPosY, null);
            if (mouseX <= itemPosX || mouseX >= itemPosX + 16 || mouseY <= itemPosY || mouseY >= itemPosY + 16) continue;
            guiGraphics.renderComponentTooltip(this.minecraft.font, Screen.getTooltipFromItem((Minecraft)this.minecraft, (ItemStack)stack), mouseX, mouseY);
        }
        int outputPosX = posX + 62;
        int outputPosY = posY - 31;
        guiGraphics.renderItem(this.outputItem, outputPosX, outputPosY);
        if (mouseX > outputPosX && mouseX < outputPosX + 16 && mouseY > outputPosY && mouseY < outputPosY + 16) {
            guiGraphics.renderComponentTooltip(this.minecraft.font, Screen.getTooltipFromItem((Minecraft)this.minecraft, (ItemStack)this.outputItem), mouseX, mouseY);
        }
    }
}

