/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.client.gui.journal;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import xyz.yfrostyf.toxony.client.gui.journal.JournalPages;
import xyz.yfrostyf.toxony.client.gui.journal.PageScreen;

public class TextPageScreen
extends PageScreen {
    protected static final ResourceLocation IMAGE = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"textures/gui/journal/journal_background.png");
    protected final int MAX_LINE_WIDTH = 130;
    protected static final int IMAGE_WIDTH = 203;
    protected static final int IMAGE_HEIGHT = 237;
    protected final Font font;
    protected final List<FormattedCharSequence> charSeqLines;
    protected int yOffset;

    public TextPageScreen(String translateID, int indexID, JournalPages journalPages) {
        super(translateID, indexID, journalPages);
        this.font = Minecraft.getInstance().font;
        this.charSeqLines = this.font.split((FormattedText)Component.translatable((String)translateID).withStyle(Style.EMPTY.withColor(13548929)), 130);
        this.yOffset = 0;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int backgroundPosX = (this.width - 203) / 2;
        int backgroundPosY = (this.height - 237) / 2;
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.blit(IMAGE, backgroundPosX, backgroundPosY, 0, 0, 203, 237);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int backgroundPosX = (this.width - 130) / 2;
        int backgroundPosY = (this.height - 130) / 2;
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int yOffset1 = this.yOffset;
        for (FormattedCharSequence line : this.charSeqLines) {
            guiGraphics.drawString(Minecraft.getInstance().font, line, backgroundPosX + 8, backgroundPosY - 23 + yOffset1, 0, false);
            Objects.requireNonNull(this.font);
            yOffset1 += 9;
        }
    }
}

