/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.client.gui.tooltips;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import xyz.yfrostyf.toxony.api.oils.ItemOil;
import xyz.yfrostyf.toxony.registries.DataComponentsRegistry;

public class OilTooltip
implements ClientTooltipComponent {
    public static final ResourceLocation RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"textures/gui/oil_bars.png");
    private ItemStack itemstack;
    private static final int TEXTURE_WIDTH = 58;
    private static final int TEXTURE_HEIGHT = 43;
    private static final int BAR_MAX_WIDTH = 58;
    private static final int BAR_OIL_WIDTH = 56;
    private static final int BAR_HEIGHT = 9;
    private static final int BAR_UOFFSET = 0;
    private static final int BAR_MAX_VOFFSET = 25;
    private static final int BAR_OIL_VOFFSET = 34;
    private static final int ICON_WIDTH = 20;
    private static final int ICON_HEIGHT = 20;

    public OilTooltip(OilTooltipComponent tooltipComponent) {
        this.itemstack = tooltipComponent.itemstack();
    }

    public int getHeight() {
        return 20;
    }

    public int getWidth(Font font) {
        return 56;
    }

    public void renderText(Font font, int mouseX, int mouseY, Matrix4f matrix, MultiBufferSource.BufferSource bufferSource) {
        super.renderText(font, mouseX, mouseY, matrix, bufferSource);
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        ItemOil itemoil = (ItemOil)this.itemstack.getOrDefault(DataComponentsRegistry.OIL, (Object)ItemOil.EMPTY);
        int uses = (Integer)this.itemstack.getOrDefault(DataComponentsRegistry.OIL_USES, (Object)-1);
        if (itemoil.isEmpty()) {
            return;
        }
        Holder<MobEffect> holder = itemoil.getOil().getEffects().getFirst();
        MobEffectTextureManager mobEffectTextureManager = Minecraft.getInstance().getMobEffectTextures();
        TextureAtlasSprite textureatlassprite = mobEffectTextureManager.get(holder);
        if (uses >= 0) {
            int oilBarWidth = Mth.ceil((float)(56.0f * Math.min((float)(itemoil.getMaxUses() - uses) / (float)itemoil.getMaxUses(), 1.0f)));
            guiGraphics.blit(RESOURCE, x + 20 - 1, y + 6, 0.0f, 25.0f, 58, 9, 58, 43);
            guiGraphics.blit(RESOURCE, x + 20 - 1, y + 6, 0.0f, 34.0f, oilBarWidth, 9, 58, 43);
        }
        guiGraphics.blit(RESOURCE, x, y, 0.0f, 0.0f, 20, 20, 58, 43);
        guiGraphics.blit(x + 1, y + 1, 0, 18, 18, textureatlassprite);
    }

    public record OilTooltipComponent(ItemStack itemstack) implements TooltipComponent
    {
    }
}

