/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.client.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import xyz.yfrostyf.toxony.blocks.entities.MortarPestleBlockEntity;

public class MortarPestleRenderer
implements BlockEntityRenderer<MortarPestleBlockEntity> {
    private final ModelPart pestleModel = Minecraft.getInstance().getEntityModels().bakeLayer(LAYER_LOCATION).getChild("pestle");
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"mortar_pestle_pestle"), "main");
    public static final ResourceLocation PESTLE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"textures/block/mortar_pestle_pestle.png");

    public static LayerDefinition newModelLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition pestlePart = root.addOrReplaceChild("pestle", CubeListBuilder.create().texOffs(0, 8).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-1.0f, 3.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)16, (int)16);
    }

    public MortarPestleRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(MortarPestleBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buf, int packedLight, int packedOverlay) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)PESTLE_TEXTURE);
        float coEff = blockEntity.pestleTick == 0 ? 0.0f : ((float)blockEntity.pestleTick - partialTick) / 20.0f;
        poseStack.pushPose();
        poseStack.translate(0.5, 0.2, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(45.0f + coEff * 360.0f));
        poseStack.translate(0.0, -0.125 * Math.sin((double)coEff * Math.PI), 0.125);
        this.pestleModel.xRot = 0.3926991f * (1.0f - (float)Math.sin((double)coEff * Math.PI));
        this.pestleModel.render(poseStack, buf.getBuffer(RenderType.entitySolid((ResourceLocation)PESTLE_TEXTURE)), packedLight, packedOverlay);
        poseStack.popPose();
    }
}

