/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.client.renderers.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import xyz.yfrostyf.toxony.client.models.items.FlailBallEntityModel;
import xyz.yfrostyf.toxony.entities.item.FlailBall;

@OnlyIn(value=Dist.CLIENT)
public class FlailBallRenderer
extends EntityRenderer<FlailBall> {
    private static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"textures/entity/projectiles/flail_ball.png");
    private final EntityModel<FlailBall> model;

    public FlailBallRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new FlailBallEntityModel<FlailBall>(context.bakeLayer(FlailBallEntityModel.LAYER_LOCATION));
    }

    public void render(FlailBall entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Entity entity2 = entity.getOwner();
        if (entity2 instanceof Player) {
            Player player = (Player)entity2;
            poseStack.pushPose();
            poseStack.scale(0.8f, 0.8f, 0.8f);
            poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot()) - 90.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot()) + 90.0f));
            VertexConsumer vertexconsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)this.model.renderType(this.getTextureLocation(entity)), (boolean)false, (boolean)entity.isFoil());
            this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
            poseStack.pushPose();
            poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
            poseStack.popPose();
            float f = player.getAttackAnim(partialTicks);
            float f1 = Mth.sin((float)(Mth.sqrt((float)f) * (float)Math.PI));
            Vec3 vec3 = this.getPlayerHandPos(player, f1, partialTicks);
            Vec3 vec31 = entity.getPosition(partialTicks).add(0.0, 0.1, 0.0);
            float f2 = (float)(vec3.x - vec31.x);
            float f3 = (float)(vec3.y - vec31.y);
            float f4 = (float)(vec3.z - vec31.z);
            VertexConsumer vertexConsumerLine = buffer.getBuffer(RenderType.lineStrip());
            PoseStack.Pose poseStackPose = poseStack.last();
            for (int j = 0; j <= 16; ++j) {
                FlailBallRenderer.stringVertex(f2, f3, f4, vertexConsumerLine, poseStackPose, FlailBallRenderer.fraction(j, 16), FlailBallRenderer.fraction(j + 1, 16));
            }
            super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        }
    }

    private Vec3 getPlayerHandPos(Player player, float p_340872_, float partialTick) {
        int i;
        int n = i = player.getMainArm() == HumanoidArm.RIGHT ? 1 : -1;
        if (this.entityRenderDispatcher.options.getCameraType().isFirstPerson() && player == Minecraft.getInstance().player) {
            double d4 = 960.0 / (double)((Integer)this.entityRenderDispatcher.options.fov().get()).intValue();
            Vec3 vec3 = this.entityRenderDispatcher.camera.getNearPlane().getPointOnPlane((float)i * 0.525f, -0.1f).scale(d4).yRot(p_340872_ * 0.5f).xRot(-p_340872_ * 0.7f);
            return player.getEyePosition(partialTick).add(vec3);
        }
        float f = Mth.lerp((float)partialTick, (float)player.yBodyRotO, (float)player.yBodyRot) * ((float)Math.PI / 180);
        double d0 = Mth.sin((float)f);
        double d1 = Mth.cos((float)f);
        float f1 = player.getScale();
        double d2 = (double)i * 0.35 * (double)f1;
        double d3 = 0.8 * (double)f1;
        float f2 = player.isCrouching() ? -0.1875f : 0.0f;
        return player.getEyePosition(partialTick).add(-d1 * d2 - d0 * d3, (double)f2 - 0.45 * (double)f1, -d0 * d2 + d1 * d3);
    }

    private static float fraction(int numerator, int denominator) {
        return (float)numerator / (float)denominator;
    }

    private static void stringVertex(float x, float y, float z, VertexConsumer consumer, PoseStack.Pose pose, float stringFraction, float nextStringFraction) {
        float f = x * stringFraction;
        float f1 = y * (stringFraction * stringFraction + stringFraction) * 0.5f + 0.25f;
        float f2 = z * stringFraction;
        float f3 = x * nextStringFraction - f;
        float f4 = y * (nextStringFraction * nextStringFraction + nextStringFraction) * 0.5f + 0.25f - f1;
        float f5 = z * nextStringFraction - f2;
        float f6 = Mth.sqrt((float)(f3 * f3 + f4 * f4 + f5 * f5));
        consumer.addVertex(pose, f, f1 - 0.25f, f2).setColor(0.25f, 0.25f, 0.35f, 1.0f).setNormal(pose, f3 /= f6, f4 /= f6, f5 /= f6);
    }

    public ResourceLocation getTextureLocation(FlailBall entity) {
        return TEXTURE_LOCATION;
    }
}

