/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.client.utils;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import xyz.yfrostyf.toxony.items.weapons.FlintlockItem;

public class AnimationUtils {
    public static void handleCycleAnimation(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
        int i;
        boolean isHumanoidArmRight = arm == HumanoidArm.RIGHT;
        int n = i = isHumanoidArmRight ? 1 : -1;
        if (player.isUsingItem() && player.getUseItemRemainingTicks() > 0) {
            AnimationUtils.applyItemArmTransform(poseStack, arm, equipProcess);
            poseStack.translate((float)i * -0.4785682f, -0.094387f, 0.05731531f);
            poseStack.mulPose(Axis.XP.rotationDegrees(-11.935f));
            poseStack.mulPose(Axis.YP.rotationDegrees((float)i * 65.3f));
            poseStack.mulPose(Axis.ZP.rotationDegrees((float)i * -9.785f));
            float f9 = (float)itemInHand.getUseDuration((LivingEntity)player) - ((float)player.getUseItemRemainingTicks() - partialTick + 1.0f);
            float f13 = f9 / (float)itemInHand.getUseDuration((LivingEntity)player);
            if (f13 > 1.0f) {
                f13 = 1.0f;
            }
            if (f13 > 0.1f) {
                float f16 = Mth.sin((float)((f9 - 0.1f) * 1.3f));
                float f3 = f13 - 0.1f;
                float f4 = f16 * f3;
                poseStack.translate(f4 * 0.0f, f4 * 0.004f, f4 * 0.0f);
            }
            poseStack.translate(f13 * 0.0f, f13 * 0.0f, f13 * 0.04f);
            poseStack.scale(1.0f, 1.0f, 1.0f + f13 * 0.2f);
            poseStack.mulPose(Axis.YN.rotationDegrees((float)i * 45.0f));
        } else {
            float f = -0.4f * Mth.sin((float)(Mth.sqrt((float)swingProcess) * (float)Math.PI));
            float f1 = 0.2f * Mth.sin((float)(Mth.sqrt((float)swingProcess) * ((float)Math.PI * 2)));
            float f2 = -0.2f * Mth.sin((float)(swingProcess * (float)Math.PI));
            poseStack.translate((float)i * f, f1, f2);
            AnimationUtils.applyItemArmTransform(poseStack, arm, swingProcess);
            AnimationUtils.applyItemArmAttackTransform(poseStack, arm, swingProcess);
        }
    }

    private static void applyItemArmTransform(PoseStack poseStack, HumanoidArm hand, float equippedProg) {
        int i = hand == HumanoidArm.RIGHT ? 1 : -1;
        poseStack.translate((float)i * 0.56f, -0.52f + equippedProg * -0.6f, -0.72f);
    }

    private static void applyItemArmAttackTransform(PoseStack poseStack, HumanoidArm hand, float swingProgress) {
        int i = hand == HumanoidArm.RIGHT ? 1 : -1;
        float f = Mth.sin((float)(swingProgress * swingProgress * (float)Math.PI));
        poseStack.mulPose(Axis.YP.rotationDegrees((float)i * (45.0f + f * -20.0f)));
        float f1 = Mth.sin((float)(Mth.sqrt((float)swingProgress) * (float)Math.PI));
        poseStack.mulPose(Axis.ZP.rotationDegrees((float)i * f1 * -20.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(f1 * -80.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees((float)i * -45.0f));
    }

    public static void handlePistolAnimation(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
        boolean isHumanoidArmRight = arm == HumanoidArm.RIGHT;
        int isRightArmFactor = isHumanoidArmRight ? 1 : -1;
        float remaining = (float)itemInHand.getUseDuration((LivingEntity)player) - ((float)player.getUseItemRemainingTicks() - partialTick + 1.0f);
        float progress = remaining / (float)itemInHand.getUseDuration((LivingEntity)player);
        if (player.isUsingItem() && ItemStack.matches((ItemStack)player.getUseItem(), (ItemStack)itemInHand) && !FlintlockItem.isLoaded(itemInHand) && progress < 1.0f) {
            AnimationUtils.applyItemArmTransform(poseStack, arm, equipProcess);
            if ((double)progress < 0.7) {
                poseStack.mulPose(Axis.XP.rotationDegrees(20.0f));
            } else {
                poseStack.mulPose(Axis.XP.rotationDegrees(progress * 30.0f));
            }
            poseStack.translate(0.0, (double)progress * 0.05, (double)progress * 0.05);
        } else {
            float f = -0.4f * Mth.sin((float)(Mth.sqrt((float)swingProcess) * (float)Math.PI));
            float f1 = 0.2f * Mth.sin((float)(Mth.sqrt((float)swingProcess) * ((float)Math.PI * 2)));
            float f2 = -0.2f * Mth.sin((float)(swingProcess * (float)Math.PI));
            poseStack.translate((float)isRightArmFactor * f, f1, f2);
            AnimationUtils.applyItemArmTransform(poseStack, arm, swingProcess);
            AnimationUtils.applyItemArmAttackTransform(poseStack, arm, swingProcess);
        }
    }
}

