/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import xyz.yfrostyf.toxony.ToxonyConfig;
import xyz.yfrostyf.toxony.api.affinity.Affinity;
import xyz.yfrostyf.toxony.api.tox.ToxData;
import xyz.yfrostyf.toxony.api.util.AffinityUtil;
import xyz.yfrostyf.toxony.network.SyncToxDataPacket;
import xyz.yfrostyf.toxony.registries.DataAttachmentRegistry;

public class ToxCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode toxCommand = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tox").requires(p -> p.hasPermission(2))).then(Commands.literal((String)"set").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> ToxCommand.changeTox((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), true)))))).then(Commands.literal((String)"add").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> ToxCommand.changeTox((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), false)))))).then(Commands.literal((String)"discover").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"isRevealOrHide", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1)).executes(context -> ToxCommand.discoverAffinities((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"isRevealOrHide"))))))).then(Commands.literal((String)"get").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.player()).executes(context -> ToxCommand.getTox((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"targets"))))));
        LiteralCommandNode tolCommand = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tolerance").requires(p -> p.hasPermission(2))).then(Commands.literal((String)"set").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> ToxCommand.changeTolerance((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), true)))))).then(Commands.literal((String)"add").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> ToxCommand.changeTolerance((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), false))))));
    }

    private static int changeTox(CommandSourceStack source, Collection<ServerPlayer> targets, int amount, boolean isSet) {
        String setString;
        targets.forEach(svplayer -> {
            ToxData plyToxData = (ToxData)svplayer.getData(DataAttachmentRegistry.TOX_DATA);
            float base = isSet ? 0.0f : plyToxData.getTox();
            plyToxData.setTox((float)amount + base);
            PacketDistributor.sendToPlayer((ServerPlayer)svplayer, (CustomPacketPayload)SyncToxDataPacket.create(plyToxData), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
        String string = setString = isSet ? "set" : "add";
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)("commands.tox." + setString + ".success"), (Object[])new Object[]{((ServerPlayer)targets.iterator().next()).getDisplayName(), amount}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)("commands.tox." + setString + ".success"), (Object[])new Object[]{targets.size(), amount}), true);
        }
        return targets.size();
    }

    private static int changeTolerance(CommandSourceStack source, Collection<ServerPlayer> targets, int amount, boolean isSet) {
        String setString;
        targets.forEach(svplayer -> {
            ToxData plyToxData = (ToxData)svplayer.getData(DataAttachmentRegistry.TOX_DATA);
            float base = isSet ? 0.0f : plyToxData.getTolerance();
            plyToxData.setTolerance((float)amount + base);
            PacketDistributor.sendToPlayer((ServerPlayer)svplayer, (CustomPacketPayload)SyncToxDataPacket.create(plyToxData), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
        String string = setString = isSet ? "set" : "add";
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)("commands.tolerance." + setString + ".success"), (Object[])new Object[]{((ServerPlayer)targets.iterator().next()).getDisplayName(), amount}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)("commands.tolerance." + setString + ".success"), (Object[])new Object[]{targets.size(), amount}), true);
        }
        return targets.size();
    }

    private static int getTox(CommandSourceStack source, ServerPlayer svplayer) {
        ToxData plyToxData = (ToxData)svplayer.getData(DataAttachmentRegistry.TOX_DATA);
        String setString = plyToxData.getDeathState() ? "death." : "";
        source.sendSuccess(() -> Component.translatable((String)("commands.tox.get." + setString + "success"), (Object[])new Object[]{svplayer.getDisplayName(), Float.valueOf(plyToxData.getTox()), Float.valueOf(plyToxData.getTolerance())}), true);
        source.sendSuccess(() -> Component.translatable((String)"commands.tox.get.success.affinities", (Object[])new Object[]{svplayer.getDisplayName(), plyToxData.getAffinities().toString()}), true);
        source.sendSuccess(() -> Component.translatable((String)"commands.tox.get.success.mutagens", (Object[])new Object[]{svplayer.getDisplayName(), plyToxData.getMutagens().toString()}), true);
        source.sendSuccess(() -> Component.translatable((String)"commands.tox.get.success.known_ingredients", (Object[])new Object[]{svplayer.getDisplayName(), plyToxData.getKnownIngredients().toString()}), true);
        return (int)plyToxData.getTox();
    }

    private static int discoverAffinities(CommandSourceStack source, ServerPlayer svplayer, int isRevealOrHide) {
        boolean isRevealed;
        ToxData plyToxData = (ToxData)svplayer.getData(DataAttachmentRegistry.TOX_DATA);
        boolean bl = isRevealed = isRevealOrHide != 0;
        if (isRevealed) {
            Level level = svplayer.level();
            Map<ResourceLocation, Affinity> map = AffinityUtil.getIngredientAffinityMap(level);
            for (Map.Entry<ResourceLocation, Affinity> entry : map.entrySet()) {
                Item item = (Item)BuiltInRegistries.ITEM.get(entry.getKey());
                if (item.equals(Items.AIR)) continue;
                plyToxData.addKnownIngredients(item.getDefaultInstance(), (Integer)ToxonyConfig.MIN_KNOWLEDGE_REQ.get());
            }
        } else {
            plyToxData.clearKnownIngredients();
        }
        PacketDistributor.sendToPlayer((ServerPlayer)svplayer, (CustomPacketPayload)SyncToxDataPacket.create(plyToxData), (CustomPacketPayload[])new CustomPacketPayload[0]);
        String setString = isRevealed ? "reveal" : "hide";
        source.sendSuccess(() -> Component.translatable((String)("commands.tox.discover." + setString), (Object[])new Object[]{svplayer.getDisplayName()}), true);
        return 0;
    }
}

