/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.data.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.GlobalLootModifierProvider;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootTableIdCondition;
import xyz.yfrostyf.toxony.data.datagen.loot.PiglinBarterLootModifier;
import xyz.yfrostyf.toxony.data.datagen.loot.ToxDropLootModifier;
import xyz.yfrostyf.toxony.registries.ItemRegistry;
import xyz.yfrostyf.toxony.registries.MobEffectRegistry;
import xyz.yfrostyf.toxony.registries.TagRegistry;

public class ToxonyGlobalLootModifierProvider
extends GlobalLootModifierProvider {
    public ToxonyGlobalLootModifierProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, "toxony");
    }

    protected void start() {
        this.dropUniqueWhilePoisoned("wolf_unique_tox_drop", EntityType.WOLF, (Item)ItemRegistry.VENOM_TOOTH.get(), 1, 2);
        this.dropUniqueWhilePoisoned("polar_bear_unique_tox_drop", EntityType.POLAR_BEAR, (Item)ItemRegistry.VENOM_TOOTH.get(), 2, 3);
        this.dropUniqueWhilePoisoned("slime_unique_tox_drop", EntityType.SLIME, (Item)ItemRegistry.ACID_SLIMEBALL.get(), 0, 1);
        this.dropUniqueWhilePoisoned("llama_unique_tox_drop", EntityType.LLAMA, (Item)ItemRegistry.TOXIC_SPIT.get(), 1, 2);
        this.dropUniqueWhilePoisoned("trader_llama_unique_tox_drop", EntityType.TRADER_LLAMA, (Item)ItemRegistry.TOXIC_SPIT.get(), 1, 2);
        this.dropUniqueWhilePoisoned("squid_unique_tox_drop", EntityType.SQUID, (Item)ItemRegistry.POISON_SAC.get(), 1, 2);
        this.dropUniqueWhilePoisoned("glow_squid_unique_tox_drop", EntityType.GLOW_SQUID, (Item)ItemRegistry.POISON_SAC.get(), 1, 2);
        this.dropUniqueWhileScalpel("bogged_unique_tox_drop", EntityType.BOGGED, (Item)ItemRegistry.BOG_BONE.get(), 1, 2);
        this.addPiglinBarterItem("bloodroot_barter_drop", (Item)ItemRegistry.BLOODROOT.get(), 1, 2);
    }

    private void addPiglinBarterItem(String name, Item dropItem, int min, int max) {
        LootItemCondition lootTableIdCondition = LootTableIdCondition.builder((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"gameplay/piglin_bartering")).build();
        this.add(name, (IGlobalLootModifier)new PiglinBarterLootModifier(new LootItemCondition[]{lootTableIdCondition}, dropItem, min, max), new ICondition[0]);
    }

    private void dropUniqueWhilePoisoned(String name, EntityType entity, Item dropItem, int min, int max) {
        EntityEquipmentPredicate equipmentPredicate = EntityEquipmentPredicate.Builder.equipment().mainhand(ItemPredicate.Builder.item().of(TagRegistry.SCALPEL_ITEM)).build();
        LootItemCondition.Builder attackerHasScalpelPredicate = LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.ATTACKER, (EntityPredicate.Builder)EntityPredicate.Builder.entity().equipment(equipmentPredicate));
        LootItemCondition.Builder poisonedEntityCondition = LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().of(entity).effects(MobEffectsPredicate.Builder.effects().and(MobEffects.POISON)));
        LootItemCondition.Builder toxinedEntityCondition = LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().of(entity).effects(MobEffectsPredicate.Builder.effects().and(MobEffectRegistry.TOXIN)));
        this.add(name, (IGlobalLootModifier)new ToxDropLootModifier(new LootItemCondition[]{AnyOfCondition.anyOf((LootItemCondition.Builder[])new LootItemCondition.Builder[]{poisonedEntityCondition, toxinedEntityCondition}).build(), attackerHasScalpelPredicate.build()}, dropItem, min, max), new ICondition[0]);
    }

    private void dropUniqueWhileScalpel(String name, EntityType entity, Item dropItem, int min, int max) {
        EntityEquipmentPredicate equipmentPredicate = EntityEquipmentPredicate.Builder.equipment().mainhand(ItemPredicate.Builder.item().of(TagRegistry.SCALPEL_ITEM)).build();
        LootItemCondition.Builder entityCondition = LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().of(entity));
        LootItemCondition.Builder attackerHasScalpelPredicate = LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.ATTACKER, (EntityPredicate.Builder)EntityPredicate.Builder.entity().equipment(equipmentPredicate));
        this.add(name, (IGlobalLootModifier)new ToxDropLootModifier(new LootItemCondition[]{entityCondition.build(), attackerHasScalpelPredicate.build()}, dropItem, min, max), new ICondition[0]);
    }
}

