/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.data.datagen.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Random;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class PiglinBarterLootModifier
extends LootModifier {
    private static final Random RANDOM = new Random();
    public static final MapCodec<PiglinBarterLootModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("drop_item").forGetter(e -> e.dropItem), (App)Codec.INT.fieldOf("min").forGetter(e -> e.min), (App)Codec.INT.fieldOf("max").forGetter(e -> e.max))).apply((Applicative)inst, PiglinBarterLootModifier::new));
    private final Item dropItem;
    private final int min;
    private final int max;

    public PiglinBarterLootModifier(LootItemCondition[] conditionsIn, Item dropItem, int min, int max) {
        super(conditionsIn);
        this.dropItem = dropItem;
        this.min = min;
        this.max = max;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        int newMin = this.min;
        int newMax = this.max;
        if (generatedLoot.stream().anyMatch(i -> i.is(Items.FIRE_CHARGE)) && RANDOM.nextInt(2) == 0) {
            generatedLoot.clear();
            ItemStack stack = new ItemStack((ItemLike)this.dropItem, RANDOM.nextInt(newMax + 1 - newMin) + newMin);
            generatedLoot.add((Object)stack);
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

