/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.data.datagen.recipebuilders;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import xyz.yfrostyf.toxony.api.affinity.Affinity;
import xyz.yfrostyf.toxony.recipes.AlchemicalForgeRecipe;

public class AlchemicalForgeRecipeBuilder
implements RecipeBuilder {
    protected String suffix = "";
    protected ItemStack result;
    protected Ingredient mainIngredient;
    protected List<Affinity> affinities = new ArrayList<Affinity>(3);
    protected List<Ingredient> auxIngredient = new ArrayList<Ingredient>(2);
    protected Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public AlchemicalForgeRecipeBuilder(ItemStack result) {
        this.result = result;
    }

    public AlchemicalForgeRecipeBuilder suffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public AlchemicalForgeRecipeBuilder mainIngredient(ItemLike item) {
        this.mainIngredient = Ingredient.of((ItemLike[])new ItemLike[]{item});
        return this;
    }

    public AlchemicalForgeRecipeBuilder mainIngredient(ItemStack stack) {
        this.mainIngredient = Ingredient.of((ItemStack[])new ItemStack[]{stack});
        return this;
    }

    public AlchemicalForgeRecipeBuilder affinity(Affinity affinity) {
        this.affinities.add(affinity);
        return this;
    }

    public AlchemicalForgeRecipeBuilder auxIngredient(ItemLike item) {
        this.auxIngredient.add(Ingredient.of((ItemLike[])new ItemLike[]{item}));
        return this;
    }

    public AlchemicalForgeRecipeBuilder auxIngredient(ItemStack stack) {
        this.auxIngredient.add(Ingredient.of((ItemStack[])new ItemStack[]{stack}));
        return this;
    }

    public AlchemicalForgeRecipeBuilder auxIngredient(Ingredient ingredient) {
        this.auxIngredient.add(ingredient);
        return this;
    }

    public AlchemicalForgeRecipeBuilder auxIngredient(TagKey<Item> item) {
        this.auxIngredient.add(Ingredient.of(item));
        return this;
    }

    public AlchemicalForgeRecipeBuilder unlockedByItems(String criterionName, ItemLike ... items) {
        return this.unlockedBy(criterionName, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])items));
    }

    public AlchemicalForgeRecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public AlchemicalForgeRecipeBuilder group(String group) {
        return this;
    }

    public Item getResult() {
        return this.result.getItem();
    }

    public void build(RecipeOutput output) {
        String pathName = BuiltInRegistries.ITEM.getKey((Object)this.result.getItem()).getPath() + this.suffix;
        this.save(output, ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)pathName).withPrefix("alchemical_forge/"));
    }

    public void save(RecipeOutput output, @NotNull ResourceLocation id) {
        Advancement.Builder advancement = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement).addCriterion(arg_0, arg_1));
        AlchemicalForgeRecipe recipe = new AlchemicalForgeRecipe(this.result, this.mainIngredient, this.affinities, this.auxIngredient);
        output.accept(id, (Recipe)recipe, advancement.build(id.withPrefix("recipes/")));
    }
}

