/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.data.datagen.recipebuilders;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import org.jetbrains.annotations.NotNull;
import xyz.yfrostyf.toxony.recipes.AlembicRecipe;
import xyz.yfrostyf.toxony.recipes.PossibleAffinityIngredient;

public class AlembicRecipeBuilder
implements RecipeBuilder {
    protected ItemStack result;
    protected ItemStack remainingItem;
    protected Ingredient ingredient;
    protected Ingredient ingredientToConvert;
    protected int boiltime;
    protected Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public AlembicRecipeBuilder(ItemStack result) {
        this.result = result;
        this.boiltime = 200;
    }

    public AlembicRecipeBuilder ingredient(ItemLike item) {
        this.ingredient = Ingredient.of((ItemLike[])new ItemLike[]{item});
        return this;
    }

    public AlembicRecipeBuilder ingredient(ItemStack item) {
        this.ingredient = Ingredient.of((ItemStack[])new ItemStack[]{item});
        return this;
    }

    public AlembicRecipeBuilder ingredient(TagKey<Item> item) {
        this.ingredient = Ingredient.of(item);
        return this;
    }

    public AlembicRecipeBuilder ingredient(Ingredient ingredient) {
        this.ingredient = ingredient;
        return this;
    }

    public AlembicRecipeBuilder possibleIngredient() {
        this.ingredient = new Ingredient((ICustomIngredient)new PossibleAffinityIngredient());
        return this;
    }

    public AlembicRecipeBuilder ingredientToConvert(ItemLike item) {
        this.ingredientToConvert = Ingredient.of((ItemLike[])new ItemLike[]{item});
        return this;
    }

    public AlembicRecipeBuilder ingredientToConvert(ItemStack item) {
        this.ingredientToConvert = Ingredient.of((ItemStack[])new ItemStack[]{item});
        return this;
    }

    public AlembicRecipeBuilder ingredientToConvert(TagKey<Item> item) {
        this.ingredientToConvert = Ingredient.of(item);
        return this;
    }

    public AlembicRecipeBuilder ingredientToConvert(Ingredient ingredient) {
        this.ingredientToConvert = ingredient;
        return this;
    }

    public AlembicRecipeBuilder boilTime(int boiltime) {
        this.boiltime = boiltime;
        return this;
    }

    public AlembicRecipeBuilder remainingItem(ItemStack remaining) {
        this.remainingItem = remaining;
        return this;
    }

    public AlembicRecipeBuilder unlockedByItems(String criterionName, ItemLike ... items) {
        return this.unlockedBy(criterionName, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])items));
    }

    public AlembicRecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public AlembicRecipeBuilder group(String group) {
        return this;
    }

    public Item getResult() {
        return this.result.getItem();
    }

    public void build(RecipeOutput output) {
        String pathName = BuiltInRegistries.ITEM.getKey((Object)this.result.getItem()).getPath();
        this.save(output, ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)pathName).withPrefix("alembic/"));
    }

    public void build(RecipeOutput output, String suffix) {
        String pathName = BuiltInRegistries.ITEM.getKey((Object)this.result.getItem()).getPath() + suffix;
        this.save(output, ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)pathName).withPrefix("alembic/"));
    }

    public void save(RecipeOutput output, @NotNull ResourceLocation id) {
        Advancement.Builder advancement = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement).addCriterion(arg_0, arg_1));
        AlembicRecipe recipe = new AlembicRecipe(this.result, this.ingredient, this.ingredientToConvert, this.boiltime, Optional.ofNullable(this.remainingItem));
        output.accept(id, (Recipe)recipe, advancement.build(id.withPrefix("recipes/")));
    }
}

