/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.data.datagen.recipebuilders;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import xyz.yfrostyf.toxony.recipes.CrucibleRecipe;

public class CrucibleRecipeBuilder
implements RecipeBuilder {
    protected String suffix = "";
    protected ItemStack result;
    protected Ingredient ingredient;
    protected int cookTime;
    protected Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public CrucibleRecipeBuilder(ItemStack result) {
        this.result = result;
        this.cookTime = 200;
    }

    public CrucibleRecipeBuilder suffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public CrucibleRecipeBuilder ingredient(ItemLike item) {
        this.ingredient = Ingredient.of((ItemLike[])new ItemLike[]{item});
        return this;
    }

    public CrucibleRecipeBuilder ingredient(TagKey<Item> item) {
        this.ingredient = Ingredient.of(item);
        return this;
    }

    public CrucibleRecipeBuilder cookTime(int cookTime) {
        this.cookTime = cookTime;
        return this;
    }

    public CrucibleRecipeBuilder unlockedByItems(String criterionName, ItemLike ... items) {
        return this.unlockedBy(criterionName, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])items));
    }

    public CrucibleRecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public CrucibleRecipeBuilder group(String group) {
        return this;
    }

    public Item getResult() {
        return this.result.getItem();
    }

    public void build(RecipeOutput output) {
        String pathName = BuiltInRegistries.ITEM.getKey((Object)this.result.getItem()).getPath() + this.suffix;
        this.save(output, ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)pathName).withPrefix("crucible/"));
    }

    public void save(RecipeOutput output, @NotNull ResourceLocation id) {
        Advancement.Builder advancement = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement).addCriterion(arg_0, arg_1));
        CrucibleRecipe recipe = new CrucibleRecipe(this.result, this.ingredient, this.cookTime);
        output.accept(id, (Recipe)recipe, advancement.build(id.withPrefix("recipes/")));
    }
}

