/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.data.datagen.recipebuilders;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import org.jetbrains.annotations.NotNull;
import xyz.yfrostyf.toxony.api.affinity.Affinity;
import xyz.yfrostyf.toxony.recipes.AffinityIngredient;
import xyz.yfrostyf.toxony.recipes.MortarPestleRecipe;
import xyz.yfrostyf.toxony.recipes.PossibleAffinityIngredient;

public class MortarPestleRecipeBuilder
implements RecipeBuilder {
    protected ItemStack result;
    protected Optional<ItemStack> use = Optional.empty();
    protected NonNullList<Ingredient> ingredients = NonNullList.create();
    protected Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public MortarPestleRecipeBuilder(ItemStack result) {
        this.result = result;
    }

    public MortarPestleRecipeBuilder ingredient(ItemLike item) {
        this.ingredients.add((Object)Ingredient.of((ItemLike[])new ItemLike[]{item}));
        return this;
    }

    public MortarPestleRecipeBuilder ingredient(ItemStack item) {
        this.ingredients.add((Object)Ingredient.of((ItemStack[])new ItemStack[]{item}));
        return this;
    }

    public MortarPestleRecipeBuilder ingredient(TagKey<Item> item) {
        this.ingredients.add((Object)Ingredient.of(item));
        return this;
    }

    public MortarPestleRecipeBuilder ingredient(Affinity affinity) {
        this.ingredients.add((Object)new Ingredient((ICustomIngredient)new AffinityIngredient(affinity)));
        return this;
    }

    public MortarPestleRecipeBuilder possibleIngredient() {
        this.ingredients.add((Object)new Ingredient((ICustomIngredient)new PossibleAffinityIngredient()));
        return this;
    }

    public MortarPestleRecipeBuilder use(ItemLike item) {
        this.use = Optional.of(new ItemStack(item));
        return this;
    }

    public MortarPestleRecipeBuilder unlockedByItems(String criterionName, ItemLike ... items) {
        return this.unlockedBy(criterionName, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])items));
    }

    public MortarPestleRecipeBuilder unlockedByTag(String criterionName, TagKey<Item> tag) {
        return this.unlockedBy(criterionName, InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])((ItemPredicate[])Arrays.stream(new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of(tag)}).map(ItemPredicate.Builder::build).toArray(ItemPredicate[]::new))));
    }

    public MortarPestleRecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public MortarPestleRecipeBuilder group(String group) {
        return this;
    }

    public Item getResult() {
        return this.result.getItem();
    }

    public void build(RecipeOutput output) {
        String pathName = BuiltInRegistries.ITEM.getKey((Object)this.result.getItem()).getPath();
        this.save(output, ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)pathName).withPrefix("mortar/"));
    }

    public void build(RecipeOutput output, String suffix) {
        String pathName = BuiltInRegistries.ITEM.getKey((Object)this.result.getItem()).getPath() + suffix;
        this.save(output, ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)pathName).withPrefix("mortar/"));
    }

    public void save(RecipeOutput output, @NotNull ResourceLocation id) {
        Advancement.Builder advancement = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement).addCriterion(arg_0, arg_1));
        MortarPestleRecipe recipe = new MortarPestleRecipe(this.result, this.use, this.ingredients);
        output.accept(id, (Recipe)recipe, advancement.build(id.withPrefix("recipes/")));
    }
}

