/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.data.world;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.saveddata.SavedData;
import xyz.yfrostyf.toxony.api.affinity.Affinity;
import xyz.yfrostyf.toxony.api.registries.ToxonyRegistries;
import xyz.yfrostyf.toxony.registries.DataComponentsRegistry;

public class IngredientAffinityMapData
extends SavedData {
    private static final Random RANDOM = new Random();
    Map<ResourceLocation, Affinity> ingredientToAffinityMap;

    private IngredientAffinityMapData(Map<ResourceLocation, Affinity> ingredientToAffinityMap) {
        this.ingredientToAffinityMap = ingredientToAffinityMap;
    }

    public Map<ResourceLocation, Affinity> getIngredientToAffinityMap() {
        return this.ingredientToAffinityMap;
    }

    public static IngredientAffinityMapData create(Map<ResourceLocation, Affinity> ingredientToAffinityMap) {
        return new IngredientAffinityMapData(ingredientToAffinityMap);
    }

    public static IngredientAffinityMapData create() {
        HashMap<ResourceLocation, Affinity> createdIngredientToAffinityMap = new HashMap<ResourceLocation, Affinity>();
        ArrayList<Holder> focusedItems = new ArrayList<Holder>();
        for (Holder holder : BuiltInRegistries.ITEM.asHolderIdMap()) {
            if (!((Item)holder.value()).components().has((DataComponentType)DataComponentsRegistry.POSSIBLE_AFFINITIES.get())) continue;
            focusedItems.add(holder);
        }
        Collections.shuffle(focusedItems);
        for (Holder holder : focusedItems) {
            Pair<ResourceLocation, Affinity> pair = IngredientAffinityMapData.randIngredientToAffinity((Holder<Item>)holder, createdIngredientToAffinityMap);
            if (pair == null) continue;
            createdIngredientToAffinityMap.put((ResourceLocation)pair.getFirst(), (Affinity)pair.getSecond());
        }
        IngredientAffinityMapData data = new IngredientAffinityMapData(createdIngredientToAffinityMap);
        data.setDirty(true);
        return data;
    }

    private static Pair<ResourceLocation, Affinity> randIngredientToAffinity(Holder<Item> holder, Map<ResourceLocation, Affinity> map) {
        List refList = (List)((Item)holder.value()).components().get((DataComponentType)DataComponentsRegistry.POSSIBLE_AFFINITIES.get());
        if (refList.isEmpty()) {
            return null;
        }
        List possibleAffinities = refList.stream().map(arg_0 -> ToxonyRegistries.AFFINITY_REGISTRY.get(arg_0)).collect(Collectors.toCollection(ArrayList::new));
        HashMap<Affinity, Integer> affinitiesCountList = new HashMap<Affinity, Integer>(possibleAffinities.size());
        for (Affinity affinity : map.values()) {
            if (!possibleAffinities.contains(affinity)) continue;
            affinitiesCountList.merge(affinity, 1, Integer::sum);
        }
        if (affinitiesCountList.size() < refList.size()) {
            return new Pair((Object)holder.getKey().location(), (Object)((Affinity)possibleAffinities.get(RANDOM.nextInt(possibleAffinities.size()))));
        }
        Affinity selectedAffinity = (Affinity)possibleAffinities.get(RANDOM.nextInt(possibleAffinities.size()));
        int lowest = 100;
        for (Map.Entry entry : affinitiesCountList.entrySet()) {
            if ((Integer)entry.getValue() >= lowest) continue;
            selectedAffinity = (Affinity)entry.getKey();
        }
        if (selectedAffinity == null) {
            return null;
        }
        return new Pair((Object)holder.getKey().location(), (Object)selectedAffinity);
    }

    public static IngredientAffinityMapData load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        ListTag stringListTag = tag.getList("affinitymap_items", 8);
        ListTag affinityListTag = tag.getList("affinitymap_affinity", 8);
        HashMap<ResourceLocation, Affinity> map = new HashMap<ResourceLocation, Affinity>();
        for (int i = 0; i < stringListTag.size(); ++i) {
            map.put(ResourceLocation.parse((String)stringListTag.getString(i)), (Affinity)ToxonyRegistries.AFFINITY_REGISTRY.get(ResourceLocation.parse((String)affinityListTag.getString(i))));
        }
        return new IngredientAffinityMapData(map);
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        ListTag stringListTag = new ListTag();
        ListTag affinityListTag = new ListTag();
        for (Map.Entry<ResourceLocation, Affinity> entry : this.ingredientToAffinityMap.entrySet()) {
            stringListTag.add((Object)StringTag.valueOf((String)entry.getKey().toString()));
            affinityListTag.add((Object)StringTag.valueOf((String)ToxonyRegistries.AFFINITY_REGISTRY.holders().filter(ref -> ((Affinity)ref.value()).equals(entry.getValue())).findFirst().get().getKey().location().toString()));
        }
        tag.put("affinitymap_items", (Tag)stringListTag);
        tag.put("affinitymap_affinity", (Tag)affinityListTag);
        return tag;
    }

    public static SavedData.Factory<IngredientAffinityMapData> factory() {
        return new SavedData.Factory(IngredientAffinityMapData::create, IngredientAffinityMapData::load);
    }
}

