/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.effects;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import xyz.yfrostyf.toxony.registries.MobEffectRegistry;
import xyz.yfrostyf.toxony.registries.ParticleRegistry;

public class CrippleMobEffect
extends MobEffect {
    private static final AttributeModifier SPEED_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"cripple_speed_modifier"), -0.25, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    private static final int color = 7221035;

    public CrippleMobEffect(MobEffectCategory category) {
        super(category, 7221035);
    }

    public ParticleOptions createParticleOptions(MobEffectInstance effect) {
        return (ParticleOptions)ParticleRegistry.BLOOD_DRIP.get();
    }

    public void onEffectStarted(LivingEntity entity, int amplifier) {
        AttributeInstance atrInstance = entity.getAttribute(Attributes.MOVEMENT_SPEED);
        if (atrInstance != null) {
            atrInstance.addOrReplacePermanentModifier(SPEED_MODIFIER);
        }
    }

    @EventBusSubscriber
    public static class CrippleEvents {
        @SubscribeEvent
        public static void onEffectRemove(MobEffectEvent.Remove event) {
            MobEffectInstance effectInst = event.getEffectInstance();
            AttributeInstance atrInstance = event.getEntity().getAttribute(Attributes.MOVEMENT_SPEED);
            if (effectInst != null && atrInstance != null && effectInst.is(MobEffectRegistry.CRIPPLE)) {
                atrInstance.removeModifier(SPEED_MODIFIER);
            }
        }

        @SubscribeEvent
        public static void onLivingDamageWithCripple(LivingDamageEvent.Pre event) {
            LivingEntity victim = event.getEntity();
            MobEffectInstance effectInst = victim.getEffect(MobEffectRegistry.CRIPPLE);
            if (effectInst == null) {
                return;
            }
            float damage = event.getNewDamage();
            DamageSource source = event.getSource();
            float dmgMod = 0.0f;
            if (source.is(DamageTypes.GENERIC) || source.is(DamageTypes.PLAYER_ATTACK) || source.is(DamageTypes.ARROW) || source.is(DamageTypes.TRIDENT) || source.is(DamageTypes.MOB_ATTACK) || source.is(DamageTypes.MOB_PROJECTILE)) {
                dmgMod = 0.25f + (float)effectInst.getAmplifier() / 4.0f;
            } else if (source.is(DamageTypes.FALL)) {
                dmgMod = 0.5f + (float)effectInst.getAmplifier() / 2.0f;
            }
            event.setNewDamage(damage + damage * dmgMod);
        }
    }
}

