/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.effects;

import java.util.stream.Stream;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import xyz.yfrostyf.toxony.registries.TagRegistry;

public class FlammableMobEffect
extends MobEffect {
    private static final int color = 7221035;

    public FlammableMobEffect(MobEffectCategory category) {
        super(category, 7221035);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        Level level = livingEntity.level();
        if (level instanceof ServerLevel) {
            AABB area;
            Stream blocksInArea;
            ServerLevel svlevel = (ServerLevel)level;
            if (!livingEntity.isOnFire() && (blocksInArea = svlevel.getBlockStates(area = new AABB(livingEntity.getOnPos()).inflate((double)(2 + amplifier)))).anyMatch(block -> block.is(TagRegistry.OPEN_FLAME))) {
                livingEntity.igniteForSeconds((float)(6 + amplifier * 3));
            }
        }
        return true;
    }
}

