/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.effects;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import xyz.yfrostyf.toxony.registries.MobEffectRegistry;

public class HuntMobEffect
extends MobEffect {
    private static final int color = 7221035;

    public HuntMobEffect(MobEffectCategory category) {
        super(category, 7221035);
    }

    public void onMobHurt(LivingEntity livingEntity, int amplifier, DamageSource damageSource, float amount) {
    }

    @EventBusSubscriber
    public static class HuntEvents {
        @SubscribeEvent
        public static void onLivingDamageWithHunt(LivingDamageEvent.Pre event) {
            LivingEntity attacker;
            LivingEntity victim = event.getEntity();
            MobEffectInstance effectInst = victim.getEffect(MobEffectRegistry.HUNT);
            if (effectInst == null) {
                return;
            }
            Entity entity = event.getSource().getEntity();
            if (entity instanceof LivingEntity && ((attacker = (LivingEntity)entity).hasEffect(MobEffectRegistry.BEAST_MUTAGEN) || attacker.getType() == EntityType.WOLF)) {
                float damage = event.getOriginalDamage();
                float dmgMod = attacker.getType() == EntityType.WOLF ? 0.5f + (float)effectInst.getAmplifier() / 4.0f : 0.25f + (float)effectInst.getAmplifier() / 4.0f;
                event.setNewDamage(damage + damage * dmgMod);
            }
        }
    }
}

