/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.effects;

import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.common.EffectCure;
import xyz.yfrostyf.toxony.damages.ToxinDamageSource;

public class ToxinMobEffect
extends MobEffect {
    private static final int color = 7261750;
    private static final int BASE_TICK = 50;

    public void fillEffectCures(Set<EffectCure> cures, MobEffectInstance effectInstance) {
        cures.clear();
    }

    public ToxinMobEffect(MobEffectCategory category) {
        super(category, 7261750);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (entity.level().isClientSide()) {
            return true;
        }
        int tick = entity.level().getServer().getTickCount();
        if (tick % this.getTickRateFromAmp(amplifier) == 0) {
            entity.hurt((DamageSource)new ToxinDamageSource((Holder<DamageType>)entity.registryAccess().lookupOrThrow(Registries.DAMAGE_TYPE).getOrThrow(DamageTypes.MAGIC), null), 3.0f + (float)amplifier);
        }
        return true;
    }

    private int getTickRateFromAmp(int amplifier) {
        return (int)(50.0 / (0.5 * (double)amplifier + 1.0));
    }
}

