/*
 * Decompiled with CFR 0.152.
 */
package xyz.yfrostyf.toxony.effects.mutagens;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;
import xyz.yfrostyf.toxony.api.mutagens.MutagenData;
import xyz.yfrostyf.toxony.api.mutagens.MutagenEffect;
import xyz.yfrostyf.toxony.api.util.CompatibilityUtil;
import xyz.yfrostyf.toxony.registries.DataAttachmentRegistry;
import xyz.yfrostyf.toxony.registries.MobEffectRegistry;
import xyz.yfrostyf.toxony.registries.ParticleRegistry;

public class AquaMutagenEffect
extends MutagenEffect {
    public static final String WATER_SPLASH_ACTIVE = "water_splash_active";
    public static final String WATER_SPLASH_COOLDOWN = "water_splash_cooldown";
    public static final int DEFAULT_SPLASH_COOLDOWN = 40;
    private static final AttributeModifier SWIM_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"aqua_mutagen_swim_modifier"), (double)0.4f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    private static final AttributeModifier SUBMERGEDMINING_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"aqua_mutagen_submergedmining_modifier"), 4.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    private static final AttributeModifier OXYGEN_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"aqua_mutagen_oxygen_add"), 2.0, AttributeModifier.Operation.ADD_VALUE);
    private static final AttributeModifier OXYGEN_ENHANCED_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"aqua_mutagen_oxygen_mul"), 2.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    private static final String ICE_SPELL_POWER = "ice_spell_power";
    private static final AttributeModifier ICE_SPELLPOWER_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"toxony", (String)"ice_spell_power_modifier"), (double)0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);

    public AquaMutagenEffect(MobEffectCategory category) {
        super(category, 0xFFFFFF);
    }

    public void onEffectStarted(LivingEntity entity, int amplifier) {
        if (amplifier >= 0) {
            AquaMutagenEffect.addModifier(entity, (Holder<Attribute>)Attributes.OXYGEN_BONUS, OXYGEN_MODIFIER);
        }
        if (amplifier >= 1) {
            AquaMutagenEffect.addModifier(entity, (Holder<Attribute>)Attributes.SUBMERGED_MINING_SPEED, SUBMERGEDMINING_MODIFIER);
            AquaMutagenEffect.addModifier(entity, (Holder<Attribute>)NeoForgeMod.SWIM_SPEED, SWIM_MODIFIER);
            Optional<Holder.Reference<Attribute>> ironsSpellOptional = CompatibilityUtil.getModAttribute(entity.level(), "irons_spellbooks", ICE_SPELL_POWER);
            ironsSpellOptional.ifPresent(attribute -> AquaMutagenEffect.addModifier(entity, (Holder<Attribute>)((Holder)ironsSpellOptional.get()), ICE_SPELLPOWER_MODIFIER));
        }
        if (amplifier >= 2) {
            AquaMutagenEffect.addModifier(entity, (Holder<Attribute>)Attributes.OXYGEN_BONUS, OXYGEN_ENHANCED_MODIFIER);
        }
    }

    @Override
    public void removeModifiers(LivingEntity entity) {
        super.removeModifiers(entity);
        AquaMutagenEffect.removeModifier(entity, (Holder<Attribute>)Attributes.OXYGEN_BONUS, OXYGEN_MODIFIER);
        AquaMutagenEffect.removeModifier(entity, (Holder<Attribute>)Attributes.SUBMERGED_MINING_SPEED, SUBMERGEDMINING_MODIFIER);
        AquaMutagenEffect.removeModifier(entity, (Holder<Attribute>)NeoForgeMod.SWIM_SPEED, SWIM_MODIFIER);
        AquaMutagenEffect.removeModifier(entity, (Holder<Attribute>)Attributes.OXYGEN_BONUS, OXYGEN_ENHANCED_MODIFIER);
        Optional<Holder.Reference<Attribute>> ironsSpellOptional = CompatibilityUtil.getModAttribute(entity.level(), "irons_spellbooks", ICE_SPELL_POWER);
        ironsSpellOptional.ifPresent(attribute -> AquaMutagenEffect.removeModifier(entity, (Holder<Attribute>)((Holder)ironsSpellOptional.get()), ICE_SPELLPOWER_MODIFIER));
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        MutagenData mutagenData = (MutagenData)livingEntity.getData(DataAttachmentRegistry.MUTAGEN_DATA);
        if (amplifier >= 2 && !livingEntity.level().isClientSide) {
            if (livingEntity.isInWaterRainOrBubble() && !livingEntity.hasEffect(MobEffects.REGENERATION)) {
                livingEntity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 20, 0, false, false));
            }
            if (!mutagenData.getBool(WATER_SPLASH_ACTIVE)) {
                int cooldown = mutagenData.getInt(WATER_SPLASH_COOLDOWN);
                mutagenData.addInt(WATER_SPLASH_COOLDOWN, cooldown - 1);
                if (cooldown <= 0) {
                    mutagenData.addBool(WATER_SPLASH_ACTIVE, true);
                }
            }
        }
        return true;
    }

    @EventBusSubscriber
    public static class AquaMutagenEvents {
        @SubscribeEvent
        public static void onMutagenDamaged(LivingDamageEvent.Pre event) {
            Holder damageType;
            MobEffectInstance victimMutagen = event.getEntity().getEffect(MobEffectRegistry.AQUA_MUTAGEN);
            if (victimMutagen == null) {
                return;
            }
            if (victimMutagen.getAmplifier() >= 2 && (damageType = event.getSource().typeHolder()).is(DamageTypeTags.IS_FIRE)) {
                event.setNewDamage(event.getOriginalDamage() * 1.3f);
            }
        }

        @SubscribeEvent
        public static void onMobKnockbackSplash(LivingKnockBackEvent event) {
            MutagenData causingMutagenData;
            Level level;
            LivingEntity victimEntity = event.getEntity();
            LivingEntity causingEntity = victimEntity.getLastHurtByMob();
            if (causingEntity == null || !causingEntity.hasEffect(MobEffectRegistry.AQUA_MUTAGEN) || !((level = event.getEntity().level()) instanceof ServerLevel)) {
                return;
            }
            ServerLevel svlevel = (ServerLevel)level;
            MobEffectInstance causingMutagen = causingEntity.getEffect(MobEffectRegistry.AQUA_MUTAGEN);
            int timeDifference = victimEntity.tickCount - victimEntity.getLastHurtByMobTimestamp();
            if (timeDifference == 0 && causingMutagen.getAmplifier() >= 2 && (causingMutagenData = (MutagenData)causingEntity.getData(DataAttachmentRegistry.MUTAGEN_DATA)).getBool(AquaMutagenEffect.WATER_SPLASH_ACTIVE)) {
                event.setStrength(event.getOriginalStrength() * 3.0f);
                svlevel.sendParticles((ParticleOptions)((SimpleParticleType)ParticleRegistry.AQUA_SPLASH.get()), victimEntity.getX(), victimEntity.getEyeY() - (double)0.2f, victimEntity.getZ(), 1, 0.1, 0.1, 0.1, 0.0);
                svlevel.sendParticles((ParticleOptions)ParticleTypes.SPLASH, victimEntity.getX(), victimEntity.getEyeY() - (double)0.2f, victimEntity.getZ(), 30, 0.3, 0.3, 0.3, 0.0);
                svlevel.playSound(null, (Entity)victimEntity, SoundEvents.GENERIC_SPLASH, SoundSource.NEUTRAL, 1.5f, 0.9f);
                causingMutagenData.addBool(AquaMutagenEffect.WATER_SPLASH_ACTIVE, false);
                causingMutagenData.addInt(AquaMutagenEffect.WATER_SPLASH_COOLDOWN, 40);
            }
        }
    }
}

